/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.bundling.RequestBuilder;
import com.google.api.gax.grpc.BundledRequestIssuer;
import com.google.api.gax.grpc.BundlingDescriptor;
import com.google.api.gax.grpc.BundlingFuture;
import com.google.api.gax.grpc.UnaryCallable;
import java.util.ArrayList;
import java.util.List;

public class Bundle<RequestT, ResponseT> {
    private final List<BundledRequestIssuer<ResponseT>> requestIssuerList;
    private final RequestBuilder<RequestT> requestBuilder;
    private UnaryCallable<RequestT, ResponseT> callable;
    private long byteCount;

    public Bundle(BundlingDescriptor<RequestT, ResponseT> descriptor, RequestT request, UnaryCallable<RequestT, ResponseT> callable, BundlingFuture<ResponseT> bundlingFuture) {
        this.requestBuilder = descriptor.getRequestBuilder();
        this.requestIssuerList = new ArrayList<BundledRequestIssuer<ResponseT>>();
        this.requestBuilder.appendRequest(request);
        this.callable = callable;
        this.requestIssuerList.add(new BundledRequestIssuer<ResponseT>(bundlingFuture, descriptor.countElements(request)));
        this.byteCount = descriptor.countBytes(request);
    }

    public RequestT getRequest() {
        return this.requestBuilder.build();
    }

    public UnaryCallable<RequestT, ResponseT> getCallable() {
        return this.callable;
    }

    public List<BundledRequestIssuer<ResponseT>> getRequestIssuerList() {
        return this.requestIssuerList;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void merge(Bundle<RequestT, ResponseT> bundle) {
        this.requestBuilder.appendRequest(bundle.getRequest());
        this.requestIssuerList.addAll(bundle.requestIssuerList);
        if (this.callable == null) {
            this.callable = bundle.callable;
        }
        this.byteCount += bundle.byteCount;
    }
}

