/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.bundling;

import com.google.api.gax.bundling.BundleMerger;
import com.google.api.gax.bundling.BundlingFlowController;
import com.google.api.gax.bundling.BundlingThreshold;
import com.google.api.gax.bundling.ThresholdBundleReceiver;
import com.google.api.gax.core.ApiFuture;
import com.google.api.gax.core.ApiFutures;
import com.google.api.gax.core.FlowController;
import com.google.api.gax.core.Function;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.Duration;

public final class ThresholdBundler<E> {
    private final Runnable pushCurrentBundleRunnable = new Runnable(){

        @Override
        public void run() {
            ThresholdBundler.this.pushCurrentBundle();
        }
    };
    private final ArrayList<BundlingThreshold<E>> thresholds;
    private final ScheduledExecutorService executor;
    private final Duration maxDelay;
    private final ThresholdBundleReceiver<E> receiver;
    private final BundlingFlowController<E> flowController;
    private final BundleMerger<E> bundleMerger;
    private final ReentrantLock lock = new ReentrantLock();
    private E currentOpenBundle;
    private Future<?> currentAlarmFuture;

    private ThresholdBundler(Builder<E> builder) {
        this.thresholds = new ArrayList(((Builder)builder).thresholds);
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)((Builder)builder).executor);
        this.maxDelay = (Duration)Preconditions.checkNotNull((Object)((Builder)builder).maxDelay);
        this.receiver = (ThresholdBundleReceiver)Preconditions.checkNotNull((Object)((Builder)builder).receiver);
        this.flowController = (BundlingFlowController)Preconditions.checkNotNull((Object)((Builder)builder).flowController);
        this.bundleMerger = (BundleMerger)Preconditions.checkNotNull((Object)((Builder)builder).bundleMerger);
        this.resetThresholds();
    }

    public static <E> Builder<E> newBuilder() {
        return new Builder();
    }

    public void add(E e) throws FlowController.FlowControlException {
        this.flowController.reserve(e);
        this.lock.lock();
        try {
            this.receiver.validateBundle(e);
            boolean anyThresholdReached = this.isAnyThresholdReached(e);
            if (this.currentOpenBundle == null) {
                this.currentOpenBundle = e;
                if (!anyThresholdReached) {
                    this.currentAlarmFuture = this.executor.schedule(this.pushCurrentBundleRunnable, this.maxDelay.getMillis(), TimeUnit.MILLISECONDS);
                }
            } else {
                this.bundleMerger.merge(this.currentOpenBundle, e);
            }
            if (anyThresholdReached) {
                this.pushCurrentBundle();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.currentOpenBundle == null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @VisibleForTesting
    public ApiFuture<Void> pushCurrentBundle() {
        E bundle = this.removeBundle();
        if (bundle == null) {
            return ApiFutures.immediateFuture(null);
        }
        return ApiFutures.transform(this.receiver.processBundle(bundle), new ReleaseResourcesFunction(bundle));
    }

    private E removeBundle() {
        this.lock.lock();
        try {
            E bundle = this.currentOpenBundle;
            this.currentOpenBundle = null;
            if (this.currentAlarmFuture != null) {
                this.currentAlarmFuture.cancel(false);
                this.currentAlarmFuture = null;
            }
            this.resetThresholds();
            E e = bundle;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isAnyThresholdReached(E e) {
        for (BundlingThreshold<E> threshold : this.thresholds) {
            threshold.accumulate(e);
            if (!threshold.isThresholdReached()) continue;
            return true;
        }
        return false;
    }

    private void resetThresholds() {
        for (int i = 0; i < this.thresholds.size(); ++i) {
            this.thresholds.set(i, this.thresholds.get(i).copyWithZeroedValue());
        }
    }

    public static class Builder<E> {
        private Collection<BundlingThreshold<E>> thresholds;
        private ScheduledExecutorService executor;
        private Duration maxDelay;
        private ThresholdBundleReceiver<E> receiver;
        private BundlingFlowController<E> flowController;
        private BundleMerger<E> bundleMerger;

        private Builder() {
        }

        public Builder<E> setExecutor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder<E> setMaxDelay(Duration maxDelay) {
            this.maxDelay = maxDelay;
            return this;
        }

        public Builder<E> setThresholds(Collection<BundlingThreshold<E>> thresholds) {
            this.thresholds = thresholds;
            return this;
        }

        public Builder<E> setReceiver(ThresholdBundleReceiver<E> receiver) {
            this.receiver = receiver;
            return this;
        }

        public Builder<E> setFlowController(BundlingFlowController<E> flowController) {
            this.flowController = flowController;
            return this;
        }

        public Builder<E> setBundleMerger(BundleMerger<E> bundleMerger) {
            this.bundleMerger = bundleMerger;
            return this;
        }

        public ThresholdBundler<E> build() {
            return new ThresholdBundler(this);
        }
    }

    private class ReleaseResourcesFunction<T>
    implements Function<T, Void> {
        private final E bundle;

        private ReleaseResourcesFunction(E bundle) {
            this.bundle = bundle;
        }

        @Override
        public Void apply(T input) {
            ThresholdBundler.this.flowController.release(this.bundle);
            return null;
        }
    }
}

