/*
 * Decompiled with CFR 0.152.
 */
package com.google.longrunning;

import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.DeleteOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.ListOperationsRequest;
import com.google.longrunning.ListOperationsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsGrpc;
import com.google.longrunning.PagedResponseWrappers;
import com.google.protobuf.Empty;
import io.grpc.Status;
import java.io.IOException;
import java.util.Set;
import org.joda.time.Duration;

public class OperationsSettings
extends ClientSettings {
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private final SimpleCallSettings<GetOperationRequest, Operation> getOperationSettings;
    private final PagedCallSettings<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsSettings;
    private final SimpleCallSettings<CancelOperationRequest, Empty> cancelOperationSettings;
    private final SimpleCallSettings<DeleteOperationRequest, Empty> deleteOperationSettings;
    private static final PagedListDescriptor<ListOperationsRequest, ListOperationsResponse, Operation> LIST_OPERATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListOperationsRequest, ListOperationsResponse, Operation>(){

        @Override
        public Object emptyToken() {
            return OperationsSettings.DEFAULT_GAPIC_VERSION;
        }

        @Override
        public ListOperationsRequest injectToken(ListOperationsRequest payload, Object token) {
            return ListOperationsRequest.newBuilder((ListOperationsRequest)payload).setPageToken((String)token).build();
        }

        @Override
        public ListOperationsRequest injectPageSize(ListOperationsRequest payload, int pageSize) {
            return ListOperationsRequest.newBuilder((ListOperationsRequest)payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListOperationsRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public Object extractNextToken(ListOperationsResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Operation> extractResources(ListOperationsResponse payload) {
            return payload.getOperationsList();
        }
    };
    private static final PagedListResponseFactory<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> LIST_OPERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse>(){

        @Override
        public PagedResponseWrappers.ListOperationsPagedResponse createPagedListResponse(UnaryCallable<ListOperationsRequest, ListOperationsResponse> callable, ListOperationsRequest request, CallContext context) {
            return new PagedResponseWrappers.ListOperationsPagedResponse(callable, LIST_OPERATIONS_PAGE_STR_DESC, request, context);
        }
    };

    public SimpleCallSettings<GetOperationRequest, Operation> getOperationSettings() {
        return this.getOperationSettings;
    }

    public PagedCallSettings<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsSettings() {
        return this.listOperationsSettings;
    }

    public SimpleCallSettings<CancelOperationRequest, Empty> cancelOperationSettings() {
        return this.cancelOperationSettings;
    }

    public SimpleCallSettings<DeleteOperationRequest, Empty> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder();
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setPort(443).setGeneratorHeader(DEFAULT_GAPIC_NAME, OperationsSettings.getGapicVersion()).setCredentialsProvider(OperationsSettings.defaultCredentialsProviderBuilder().build());
    }

    private static String getGapicVersion() {
        String packageVersion = OperationsSettings.class.getPackage().getImplementationVersion();
        return packageVersion != null ? packageVersion : DEFAULT_GAPIC_VERSION;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private OperationsSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider());
        this.getOperationSettings = settingsBuilder.getOperationSettings().build();
        this.listOperationsSettings = settingsBuilder.listOperationsSettings().build();
        this.cancelOperationSettings = settingsBuilder.cancelOperationSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<GetOperationRequest, Operation> getOperationSettings;
        private final PagedCallSettings.Builder<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsSettings;
        private final SimpleCallSettings.Builder<CancelOperationRequest, Empty> cancelOperationSettings;
        private final SimpleCallSettings.Builder<DeleteOperationRequest, Empty> deleteOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super((InstantiatingChannelProvider)null);
            this.getOperationSettings = SimpleCallSettings.newBuilder(OperationsGrpc.METHOD_GET_OPERATION);
            this.listOperationsSettings = PagedCallSettings.newBuilder(OperationsGrpc.METHOD_LIST_OPERATIONS, LIST_OPERATIONS_PAGE_STR_FACT);
            this.cancelOperationSettings = SimpleCallSettings.newBuilder(OperationsGrpc.METHOD_CANCEL_OPERATION);
            this.deleteOperationSettings = SimpleCallSettings.newBuilder(OperationsGrpc.METHOD_DELETE_OPERATION);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getOperationSettings, this.listOperationsSettings, this.cancelOperationSettings, this.deleteOperationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            ((SimpleCallSettings.Builder)builder.getOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent"))).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            ((PagedCallSettings.Builder)builder.listOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent"))).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            ((SimpleCallSettings.Builder)builder.cancelOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent"))).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            ((SimpleCallSettings.Builder)builder.deleteOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent"))).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(OperationsSettings settings) {
            super(settings);
            this.getOperationSettings = settings.getOperationSettings.toBuilder();
            this.listOperationsSettings = settings.listOperationsSettings.toBuilder();
            this.cancelOperationSettings = settings.cancelOperationSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getOperationSettings, this.listOperationsSettings, this.cancelOperationSettings, this.deleteOperationSettings);
        }

        @Override
        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        @Override
        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods((Iterable<UnaryCallSettings.Builder>)this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<GetOperationRequest, Operation> getOperationSettings() {
            return this.getOperationSettings;
        }

        public PagedCallSettings.Builder<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsSettings() {
            return this.listOperationsSettings;
        }

        public SimpleCallSettings.Builder<CancelOperationRequest, Empty> cancelOperationSettings() {
            return this.cancelOperationSettings;
        }

        public SimpleCallSettings.Builder<DeleteOperationRequest, Empty> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        @Override
        public OperationsSettings build() throws IOException {
            return new OperationsSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)20000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

