/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.bundling.BundleMerger;
import com.google.api.gax.bundling.BundlingFlowController;
import com.google.api.gax.bundling.BundlingSettings;
import com.google.api.gax.bundling.BundlingThreshold;
import com.google.api.gax.bundling.ElementCounter;
import com.google.api.gax.bundling.NumericThreshold;
import com.google.api.gax.bundling.ThresholdBundler;
import com.google.api.gax.bundling.ThresholdBundlingForwarder;
import com.google.api.gax.core.FlowControlSettings;
import com.google.api.gax.core.FlowController;
import com.google.api.gax.grpc.Bundle;
import com.google.api.gax.grpc.BundleExecutor;
import com.google.api.gax.grpc.BundlingDescriptor;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class BundlerFactory<RequestT, ResponseT>
implements AutoCloseable {
    private final Map<String, ThresholdBundlingForwarder<Bundle<RequestT, ResponseT>>> forwarders = new ConcurrentHashMap<String, ThresholdBundlingForwarder<Bundle<RequestT, ResponseT>>>();
    private final BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor;
    private final FlowController flowController;
    private final BundlingSettings bundlingSettings;
    private final Object lock = new Object();

    public BundlerFactory(BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor, BundlingSettings bundlingSettings) {
        this.bundlingDescriptor = bundlingDescriptor;
        this.bundlingSettings = bundlingSettings;
        this.flowController = new FlowController(bundlingSettings.getFlowControlSettings() != null ? bundlingSettings.getFlowControlSettings() : FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThresholdBundlingForwarder<Bundle<RequestT, ResponseT>> getForwarder(String partitionKey) {
        ThresholdBundlingForwarder<Bundle<RequestT, ResponseT>> forwarder = this.forwarders.get(partitionKey);
        if (forwarder == null) {
            Object object = this.lock;
            synchronized (object) {
                forwarder = this.forwarders.get(partitionKey);
                if (forwarder == null) {
                    forwarder = this.createForwarder(partitionKey);
                    this.forwarders.put(partitionKey, forwarder);
                    forwarder.start();
                }
            }
        }
        return forwarder;
    }

    BundlingSettings getBundlingSettings() {
        return this.bundlingSettings;
    }

    private ThresholdBundlingForwarder<Bundle<RequestT, ResponseT>> createForwarder(String partitionKey) {
        ThresholdBundler<Bundle<RequestT, ResponseT>> bundler = ThresholdBundler.newBuilder().setThresholds(this.getThresholds(this.bundlingSettings)).setMaxDelay(this.bundlingSettings.getDelayThreshold()).setFlowController(this.createBundlingFlowController()).setBundleMerger(this.createBundleMerger()).build();
        BundleExecutor<RequestT, ResponseT> processor = new BundleExecutor<RequestT, ResponseT>(this.bundlingDescriptor, partitionKey);
        return new ThresholdBundlingForwarder<Bundle<RequestT, ResponseT>>(bundler, processor);
    }

    private BundlingFlowController<Bundle<RequestT, ResponseT>> createBundlingFlowController() {
        return new BundlingFlowController<Bundle<RequestT, ResponseT>>(this.flowController, new ElementCounter<Bundle<RequestT, ResponseT>>(){

            @Override
            public long count(Bundle<RequestT, ResponseT> bundlablePublish) {
                return BundlerFactory.this.bundlingDescriptor.countElements(bundlablePublish.getRequest());
            }
        }, new ElementCounter<Bundle<RequestT, ResponseT>>(){

            @Override
            public long count(Bundle<RequestT, ResponseT> bundlablePublish) {
                return BundlerFactory.this.bundlingDescriptor.countBytes(bundlablePublish.getRequest());
            }
        });
    }

    private BundleMerger<Bundle<RequestT, ResponseT>> createBundleMerger() {
        return new BundleMerger<Bundle<RequestT, ResponseT>>(){

            @Override
            public void merge(Bundle<RequestT, ResponseT> bundle, Bundle<RequestT, ResponseT> newBundle) {
                bundle.merge(newBundle);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            for (ThresholdBundlingForwarder<Bundle<RequestT, ResponseT>> forwarder : this.forwarders.values()) {
                forwarder.close();
            }
            this.forwarders.clear();
        }
    }

    private ImmutableList<BundlingThreshold<Bundle<RequestT, ResponseT>>> getThresholds(BundlingSettings bundlingSettings) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        if (bundlingSettings.getElementCountThreshold() != null) {
            ElementCounter elementCounter = new ElementCounter<Bundle<RequestT, ResponseT>>(){

                @Override
                public long count(Bundle<RequestT, ResponseT> bundlablePublish) {
                    return BundlerFactory.this.bundlingDescriptor.countElements(bundlablePublish.getRequest());
                }
            };
            NumericThreshold countThreshold = new NumericThreshold(bundlingSettings.getElementCountThreshold(), elementCounter);
            listBuilder.add(countThreshold);
        }
        if (bundlingSettings.getRequestByteThreshold() != null) {
            ElementCounter requestByteCounter = new ElementCounter<Bundle<RequestT, ResponseT>>(){

                @Override
                public long count(Bundle<RequestT, ResponseT> bundlablePublish) {
                    return BundlerFactory.this.bundlingDescriptor.countBytes(bundlablePublish.getRequest());
                }
            };
            NumericThreshold byteThreshold = new NumericThreshold(bundlingSettings.getRequestByteThreshold(), requestByteCounter);
            listBuilder.add(byteThreshold);
        }
        return listBuilder.build();
    }
}

