/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.BundlingFuture;
import com.google.common.base.Preconditions;

public final class BundledRequestIssuer<ResponseT> {
    private final BundlingFuture<ResponseT> bundlingFuture;
    private final long messageCount;
    private ResponseT responseToSend;
    private Throwable throwableToSend;

    public BundledRequestIssuer(BundlingFuture<ResponseT> bundlingFuture, long messageCount) {
        this.bundlingFuture = bundlingFuture;
        this.messageCount = messageCount;
        this.responseToSend = null;
        this.throwableToSend = null;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public void setResponse(ResponseT response) {
        Preconditions.checkState((this.throwableToSend == null ? 1 : 0) != 0, (Object)"Cannot set both exception and response");
        this.responseToSend = response;
    }

    public void setException(Throwable throwable) {
        Preconditions.checkState((this.throwableToSend == null ? 1 : 0) != 0, (Object)"Cannot set both exception and response");
        this.throwableToSend = throwable;
    }

    public void sendResult() {
        if (this.responseToSend != null) {
            this.bundlingFuture.set(this.responseToSend);
        } else if (this.throwableToSend != null) {
            this.bundlingFuture.setException(this.throwableToSend);
        } else {
            throw new IllegalStateException("Neither response nor exception were set in BundledRequestIssuer");
        }
    }
}

