/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.bundling;

import com.google.api.gax.bundling.ThresholdBundleReceiver;
import com.google.api.gax.bundling.ThresholdBundler;
import com.google.api.gax.core.FlowController;

public final class ThresholdBundlingForwarder<T>
implements AutoCloseable {
    private final ThresholdBundler<T> bundler;
    private final ThresholdBundleReceiver<T> bundleReceiver;
    private final BundleForwardingRunnable forwardingRunnable;
    private final Thread forwarderThread;

    public ThresholdBundlingForwarder(ThresholdBundler<T> bundler, ThresholdBundleReceiver<T> bundleReceiver) {
        this.bundleReceiver = bundleReceiver;
        this.bundler = bundler;
        this.forwardingRunnable = new BundleForwardingRunnable();
        this.forwarderThread = new Thread(this.forwardingRunnable);
    }

    public void start() {
        this.forwarderThread.start();
    }

    public void addToNextBundle(T item) throws FlowController.FlowControlException {
        this.bundleReceiver.validateBundle(item);
        this.bundler.add(item);
    }

    @Override
    public void close() {
        this.forwarderThread.interrupt();
        try {
            this.forwarderThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private class BundleForwardingRunnable
    implements Runnable {
        private BundleForwardingRunnable() {
        }

        @Override
        public void run() {
            do {
                try {
                    this.processBundle(ThresholdBundlingForwarder.this.bundler.takeBundle());
                }
                catch (InterruptedException e) {
                    break;
                }
            } while (!Thread.currentThread().isInterrupted());
            Object bundle = ThresholdBundlingForwarder.this.bundler.removeBundle();
            while (bundle != null) {
                this.processBundle(bundle);
                bundle = ThresholdBundlingForwarder.this.bundler.removeBundle();
            }
        }

        private void processBundle(T bundle) {
            if (bundle == null) {
                return;
            }
            ThresholdBundlingForwarder.this.bundleReceiver.processBundle(bundle);
        }
    }
}

