/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.bundling;

import com.google.api.gax.bundling.ElementCounter;
import com.google.api.gax.core.FlowController;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;

public class BundlingFlowController<T> {
    private final FlowController flowController;
    private final ElementCounter<T> elementCounter;
    private final ElementCounter<T> byteCounter;

    public BundlingFlowController(FlowController flowController, ElementCounter<T> elementCounter, ElementCounter<T> byteCounter) {
        this.flowController = flowController;
        this.elementCounter = elementCounter;
        this.byteCounter = byteCounter;
    }

    public void reserve(T bundle) throws FlowController.FlowControlException {
        Preconditions.checkNotNull(bundle);
        int elements = Ints.checkedCast((long)this.elementCounter.count(bundle));
        int bytes = Ints.checkedCast((long)this.byteCounter.count(bundle));
        this.flowController.reserve(elements, bytes);
    }

    public void release(T bundle) {
        Preconditions.checkNotNull(bundle);
        int elements = Ints.checkedCast((long)this.elementCounter.count(bundle));
        int bytes = Ints.checkedCast((long)this.byteCounter.count(bundle));
        this.flowController.release(elements, bytes);
    }
}

