/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import java.io.InputStream;
import java.util.Properties;

public class PropertiesProvider {
    private static final Properties gaxProperties = new Properties();
    private static final String GAX_PROPERTY_FILE = "/com/google/api/gax/gax.properties";
    private static final String DEFAULT_VERSION = "";

    public static String getGaxVersion() {
        String gaxVersion = PropertiesProvider.loadGaxProperty("version");
        return gaxVersion != null ? gaxVersion : DEFAULT_VERSION;
    }

    public static String getGrpcVersion() {
        String grpcVersion = PropertiesProvider.loadGaxProperty("grpc_version");
        return grpcVersion != null ? grpcVersion : DEFAULT_VERSION;
    }

    public static String loadProperty(Class<?> loadedClass, String propertyFilePath, String key) {
        try {
            InputStream inputStream = loadedClass.getResourceAsStream(propertyFilePath);
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                return properties.getProperty(key);
            }
            PropertiesProvider.printMissingProperties(loadedClass, propertyFilePath);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    private static String loadGaxProperty(String key) {
        try {
            if (gaxProperties.isEmpty()) {
                InputStream inputStream = PropertiesProvider.class.getResourceAsStream(GAX_PROPERTY_FILE);
                if (inputStream != null) {
                    gaxProperties.load(inputStream);
                } else {
                    PropertiesProvider.printMissingProperties(PropertiesProvider.class, GAX_PROPERTY_FILE);
                    return null;
                }
            }
            return gaxProperties.getProperty(key);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    private static void printMissingProperties(Class<?> loadedClass, String propertyFilePath) {
        System.err.format("Warning: Failed to open properties resource at '%s' of the given class '%s'\n", propertyFilePath, loadedClass.getName());
    }
}

