/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.FlowControlSettings;
import com.google.common.base.Preconditions;
import java.util.concurrent.Semaphore;
import javax.annotation.Nullable;

public class FlowController {
    @Nullable
    private final Semaphore outstandingElementCount;
    @Nullable
    private final Semaphore outstandingByteCount;
    private final boolean failOnLimits;
    @Nullable
    private final Integer maxOutstandingElementCount;
    @Nullable
    private final Integer maxOutstandingRequestBytes;

    public FlowController(FlowControlSettings settings, boolean failOnFlowControlLimits) {
        this.maxOutstandingElementCount = settings.getMaxOutstandingElementCount();
        this.maxOutstandingRequestBytes = settings.getMaxOutstandingRequestBytes();
        this.outstandingElementCount = this.maxOutstandingElementCount != null ? new Semaphore(this.maxOutstandingElementCount) : null;
        this.outstandingByteCount = this.maxOutstandingRequestBytes != null ? new Semaphore(this.maxOutstandingRequestBytes) : null;
        this.failOnLimits = failOnFlowControlLimits;
    }

    public void reserve(int elements, int bytes) throws FlowControlException {
        Preconditions.checkArgument((elements > 0 ? 1 : 0) != 0);
        if (this.outstandingElementCount != null) {
            if (!this.failOnLimits) {
                this.outstandingElementCount.acquireUninterruptibly(elements);
            } else if (!this.outstandingElementCount.tryAcquire(elements)) {
                throw new MaxOutstandingElementCountReachedException(this.maxOutstandingElementCount);
            }
        }
        if (this.outstandingByteCount != null) {
            int permitsToDraw = Math.min(bytes, this.maxOutstandingRequestBytes);
            if (!this.failOnLimits) {
                this.outstandingByteCount.acquireUninterruptibly(permitsToDraw);
            } else if (!this.outstandingByteCount.tryAcquire(permitsToDraw)) {
                throw new MaxOutstandingRequestBytesReachedException(this.maxOutstandingRequestBytes);
            }
        }
    }

    public void release(int elements, int bytes) {
        Preconditions.checkArgument((elements > 0 ? 1 : 0) != 0);
        if (this.outstandingElementCount != null) {
            this.outstandingElementCount.release(elements);
        }
        if (this.outstandingByteCount != null) {
            int permitsToReturn = Math.min(bytes, this.maxOutstandingRequestBytes);
            this.outstandingByteCount.release(permitsToReturn);
        }
    }

    public static final class MaxOutstandingRequestBytesReachedException
    extends FlowControlException {
        private final int currentMaxBytes;

        public MaxOutstandingRequestBytesReachedException(int currentMaxBytes) {
            this.currentMaxBytes = currentMaxBytes;
        }

        public int getCurrentMaxBundleBytes() {
            return this.currentMaxBytes;
        }

        @Override
        public String toString() {
            return String.format("The maximum number of bundle bytes: %d have been reached.", this.currentMaxBytes);
        }
    }

    public static final class MaxOutstandingElementCountReachedException
    extends FlowControlException {
        private final int currentMaxElementCount;

        public MaxOutstandingElementCountReachedException(int currentMaxElementCount) {
            this.currentMaxElementCount = currentMaxElementCount;
        }

        public int getCurrentMaxBundleElementCount() {
            return this.currentMaxElementCount;
        }

        @Override
        public String toString() {
            return String.format("The maximum number of bundle elements: %d have been reached.", this.currentMaxElementCount);
        }
    }

    public static abstract class FlowControlException
    extends Exception {
        private FlowControlException() {
        }
    }
}

