/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.core.RpcFuture;
import com.google.api.gax.core.RpcFutureCallback;
import com.google.api.gax.grpc.AbstractRpcFuture;
import com.google.api.gax.grpc.ApiException;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.FutureCallable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.CancellationException;

class ExceptionTransformingCallable<RequestT, ResponseT>
implements FutureCallable<RequestT, ResponseT> {
    private final FutureCallable<RequestT, ResponseT> callable;
    private final ImmutableSet<Status.Code> retryableCodes;

    ExceptionTransformingCallable(FutureCallable<RequestT, ResponseT> callable, ImmutableSet<Status.Code> retryableCodes) {
        this.callable = (FutureCallable)Preconditions.checkNotNull(callable);
        this.retryableCodes = (ImmutableSet)Preconditions.checkNotNull(retryableCodes);
    }

    @Override
    public RpcFuture<ResponseT> futureCall(RequestT request, CallContext context) {
        RpcFuture<ResponseT> innerCallFuture = this.callable.futureCall(request, context);
        ExceptionTransformingFuture transformingFuture = new ExceptionTransformingFuture(innerCallFuture);
        innerCallFuture.addCallback(transformingFuture);
        return transformingFuture;
    }

    private class ExceptionTransformingFuture
    extends AbstractRpcFuture<ResponseT>
    implements RpcFutureCallback<ResponseT> {
        private RpcFuture<ResponseT> innerCallFuture;
        private volatile boolean cancelled = false;

        public ExceptionTransformingFuture(RpcFuture<ResponseT> innerCallFuture) {
            this.innerCallFuture = innerCallFuture;
        }

        protected void interruptTask() {
            this.cancelled = true;
            this.innerCallFuture.cancel(true);
        }

        @Override
        public void onSuccess(ResponseT r) {
            super.set(r);
        }

        @Override
        public void onFailure(Throwable throwable) {
            boolean canRetry;
            Status.Code statusCode;
            if (throwable instanceof StatusException) {
                StatusException e = (StatusException)throwable;
                statusCode = e.getStatus().getCode();
                canRetry = ExceptionTransformingCallable.this.retryableCodes.contains((Object)statusCode);
            } else if (throwable instanceof StatusRuntimeException) {
                StatusRuntimeException e = (StatusRuntimeException)throwable;
                statusCode = e.getStatus().getCode();
                canRetry = ExceptionTransformingCallable.this.retryableCodes.contains((Object)statusCode);
            } else {
                if (throwable instanceof CancellationException && this.cancelled) {
                    return;
                }
                statusCode = Status.Code.UNKNOWN;
                canRetry = false;
            }
            super.setException((Throwable)new ApiException(throwable, statusCode, canRetry));
        }
    }
}

