/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.core.RpcFuture;
import com.google.api.gax.grpc.ApiExceptions;
import com.google.api.gax.grpc.BundlerFactory;
import com.google.api.gax.grpc.BundlingCallSettings;
import com.google.api.gax.grpc.BundlingCallable;
import com.google.api.gax.grpc.BundlingDescriptor;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.DefaultNanoClock;
import com.google.api.gax.grpc.ExceptionTransformingCallable;
import com.google.api.gax.grpc.FutureCallable;
import com.google.api.gax.grpc.NanoClock;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedCallable;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.RetryingCallable;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.grpc.Channel;
import io.grpc.Status;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class UnaryCallable<RequestT, ResponseT> {
    private final FutureCallable<RequestT, ResponseT> callable;
    private final Channel channel;
    @Nullable
    private final UnaryCallSettings settings;

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> create(SimpleCallSettings<RequestT, ResponseT> simpleCallSettings, Channel channel, ScheduledExecutorService executor) {
        return simpleCallSettings.create(channel, executor);
    }

    public static <RequestT, ResponseT, PagedListResponseT> UnaryCallable<RequestT, PagedListResponseT> createPagedVariant(PagedCallSettings<RequestT, ResponseT, PagedListResponseT> PagedCallSettings2, Channel channel, ScheduledExecutorService executor) {
        return PagedCallSettings2.createPagedVariant(channel, executor);
    }

    public static <RequestT, ResponseT, PagedListResponseT> UnaryCallable<RequestT, ResponseT> create(PagedCallSettings<RequestT, ResponseT, PagedListResponseT> PagedCallSettings2, Channel channel, ScheduledExecutorService executor) {
        return PagedCallSettings2.create(channel, executor);
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> create(BundlingCallSettings<RequestT, ResponseT> bundlingCallSettings, Channel channel, ScheduledExecutorService executor) {
        return bundlingCallSettings.create(channel, executor);
    }

    static <ReqT, RespT> UnaryCallable<ReqT, RespT> create(FutureCallable<ReqT, RespT> futureCallable) {
        return new UnaryCallable<ReqT, RespT>(futureCallable);
    }

    public UnaryCallSettings getSettings() {
        return this.settings;
    }

    UnaryCallable(FutureCallable<RequestT, ResponseT> callable, Channel channel, UnaryCallSettings settings) {
        this.callable = (FutureCallable)Preconditions.checkNotNull(callable);
        this.channel = channel;
        this.settings = settings;
    }

    UnaryCallable(FutureCallable<RequestT, ResponseT> callable) {
        this(callable, null, null);
    }

    public RpcFuture<ResponseT> futureCall(RequestT request, CallContext context) {
        if (context.getChannel() == null) {
            context = context.withChannel(this.channel);
        }
        return this.callable.futureCall(request, context);
    }

    public RpcFuture<ResponseT> futureCall(RequestT request) {
        return this.futureCall(request, CallContext.createDefault().withChannel(this.channel));
    }

    public ResponseT call(RequestT request, CallContext context) {
        return ApiExceptions.callAndTranslateApiException(this.futureCall(request, context));
    }

    public ResponseT call(RequestT request) {
        return ApiExceptions.callAndTranslateApiException(this.futureCall(request));
    }

    UnaryCallable<RequestT, ResponseT> bind(Channel boundChannel) {
        return new UnaryCallable<RequestT, ResponseT>(this.callable, boundChannel, this.settings);
    }

    UnaryCallable<RequestT, ResponseT> retryableOn(ImmutableSet<Status.Code> retryableCodes) {
        return new UnaryCallable<RequestT, ResponseT>(new ExceptionTransformingCallable<RequestT, ResponseT>(this.callable, retryableCodes), this.channel, this.settings);
    }

    UnaryCallable<RequestT, ResponseT> retrying(RetrySettings retrySettings, ScheduledExecutorService executor) {
        return this.retrying(retrySettings, new DelegatingScheduler(executor), DefaultNanoClock.create());
    }

    @VisibleForTesting
    UnaryCallable<RequestT, ResponseT> retrying(RetrySettings retrySettings, Scheduler executor, NanoClock clock) {
        return new UnaryCallable<RequestT, ResponseT>(new RetryingCallable<RequestT, ResponseT>(this.callable, retrySettings, executor, clock), this.channel, this.settings);
    }

    <PagedListResponseT> UnaryCallable<RequestT, PagedListResponseT> paged(PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory) {
        return new UnaryCallable<RequestT, ResponseT>(new PagedCallable<RequestT, ResponseT, PagedListResponseT>(this.callable, pagedListResponseFactory), this.channel, this.settings);
    }

    UnaryCallable<RequestT, ResponseT> bundling(BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor, BundlerFactory<RequestT, ResponseT> bundlerFactory) {
        return new UnaryCallable<RequestT, ResponseT>(new BundlingCallable<RequestT, ResponseT>(this.callable, bundlingDescriptor, bundlerFactory), this.channel, this.settings);
    }

    static class DelegatingScheduler
    implements Scheduler {
        private final ScheduledExecutorService executor;

        DelegatingScheduler(ScheduledExecutorService executor) {
            this.executor = executor;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit unit) {
            return this.executor.schedule(runnable, delay, unit);
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.executor.shutdownNow();
        }
    }

    static interface Scheduler {
        public ScheduledFuture<?> schedule(Runnable var1, long var2, TimeUnit var4);

        public List<Runnable> shutdownNow();
    }
}

