/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.BundlingSettings;
import javax.annotation.Nullable;
import org.joda.time.Duration;

final class AutoValue_BundlingSettings
extends BundlingSettings {
    private final Long elementCountThreshold;
    private final Long requestByteThreshold;
    private final Duration delayThreshold;
    private final Boolean isEnabled;

    private AutoValue_BundlingSettings(@Nullable Long elementCountThreshold, @Nullable Long requestByteThreshold, @Nullable Duration delayThreshold, Boolean isEnabled) {
        this.elementCountThreshold = elementCountThreshold;
        this.requestByteThreshold = requestByteThreshold;
        this.delayThreshold = delayThreshold;
        if (isEnabled == null) {
            throw new NullPointerException("Null isEnabled");
        }
        this.isEnabled = isEnabled;
    }

    @Override
    @Nullable
    public Long getElementCountThreshold() {
        return this.elementCountThreshold;
    }

    @Override
    @Nullable
    public Long getRequestByteThreshold() {
        return this.requestByteThreshold;
    }

    @Override
    @Nullable
    public Duration getDelayThreshold() {
        return this.delayThreshold;
    }

    @Override
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public String toString() {
        return "BundlingSettings{elementCountThreshold=" + this.elementCountThreshold + ", requestByteThreshold=" + this.requestByteThreshold + ", delayThreshold=" + this.delayThreshold + ", isEnabled=" + this.isEnabled + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BundlingSettings) {
            BundlingSettings that = (BundlingSettings)o;
            return (this.elementCountThreshold == null ? that.getElementCountThreshold() == null : this.elementCountThreshold.equals(that.getElementCountThreshold())) && (this.requestByteThreshold == null ? that.getRequestByteThreshold() == null : this.requestByteThreshold.equals(that.getRequestByteThreshold())) && (this.delayThreshold == null ? that.getDelayThreshold() == null : this.delayThreshold.equals((Object)that.getDelayThreshold())) && this.isEnabled.equals(that.getIsEnabled());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.elementCountThreshold == null ? 0 : this.elementCountThreshold.hashCode();
        h *= 1000003;
        h ^= this.requestByteThreshold == null ? 0 : this.requestByteThreshold.hashCode();
        h *= 1000003;
        h ^= this.delayThreshold == null ? 0 : this.delayThreshold.hashCode();
        h *= 1000003;
        return h ^= this.isEnabled.hashCode();
    }

    static final class Builder
    extends BundlingSettings.Builder {
        private Long elementCountThreshold;
        private Long requestByteThreshold;
        private Duration delayThreshold;
        private Boolean isEnabled;

        Builder() {
        }

        Builder(BundlingSettings source) {
            this.elementCountThreshold = source.getElementCountThreshold();
            this.requestByteThreshold = source.getRequestByteThreshold();
            this.delayThreshold = source.getDelayThreshold();
            this.isEnabled = source.getIsEnabled();
        }

        @Override
        public BundlingSettings.Builder setElementCountThreshold(@Nullable Long elementCountThreshold) {
            this.elementCountThreshold = elementCountThreshold;
            return this;
        }

        @Override
        public BundlingSettings.Builder setRequestByteThreshold(@Nullable Long requestByteThreshold) {
            this.requestByteThreshold = requestByteThreshold;
            return this;
        }

        @Override
        public BundlingSettings.Builder setDelayThreshold(@Nullable Duration delayThreshold) {
            this.delayThreshold = delayThreshold;
            return this;
        }

        @Override
        public BundlingSettings.Builder setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        @Override
        public BundlingSettings autoBuild() {
            String missing = "";
            if (this.isEnabled == null) {
                missing = missing + " isEnabled";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BundlingSettings(this.elementCountThreshold, this.requestByteThreshold, this.delayThreshold, this.isEnabled);
        }
    }
}

