/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.UnaryCallSettingsTyped;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.collect.ImmutableSet;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;

public final class PagedCallSettings<RequestT, ResponseT, PagedListResponseT>
extends UnaryCallSettingsTyped<RequestT, ResponseT> {
    private final PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory;

    UnaryCallable<RequestT, ResponseT> create(Channel channel, ScheduledExecutorService executor) {
        return this.createBaseCallable(channel, executor);
    }

    UnaryCallable<RequestT, PagedListResponseT> createPagedVariant(Channel channel, ScheduledExecutorService executor) {
        UnaryCallable<RequestT, ResponseT> baseCallable = this.createBaseCallable(channel, executor);
        return baseCallable.paged(this.pagedListResponseFactory);
    }

    public static <RequestT, ResponseT, PagedListResponseT> Builder<RequestT, ResponseT, PagedListResponseT> newBuilder(MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor, PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory) {
        return new Builder<RequestT, ResponseT, PagedListResponseT>(grpcMethodDescriptor, pagedListResponseFactory);
    }

    @Override
    public final Builder<RequestT, ResponseT, PagedListResponseT> toBuilder() {
        return new Builder(this);
    }

    private PagedCallSettings(ImmutableSet<Status.Code> retryableCodes, RetrySettings retrySettings, MethodDescriptor<RequestT, ResponseT> methodDescriptor, PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory) {
        super(retryableCodes, retrySettings, methodDescriptor);
        this.pagedListResponseFactory = pagedListResponseFactory;
    }

    public static class Builder<RequestT, ResponseT, PagedListResponseT>
    extends UnaryCallSettingsTyped.Builder<RequestT, ResponseT> {
        private PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory;

        public Builder(MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor, PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory) {
            super(grpcMethodDescriptor);
            this.pagedListResponseFactory = pagedListResponseFactory;
        }

        public Builder(PagedCallSettings<RequestT, ResponseT, PagedListResponseT> settings) {
            super(settings);
            this.pagedListResponseFactory = ((PagedCallSettings)settings).pagedListResponseFactory;
        }

        @Override
        public Builder<RequestT, ResponseT, PagedListResponseT> setRetryableCodes(Set<Status.Code> retryableCodes) {
            super.setRetryableCodes(retryableCodes);
            return this;
        }

        @Override
        public Builder<RequestT, ResponseT, PagedListResponseT> setRetryableCodes(Status.Code ... codes) {
            super.setRetryableCodes(codes);
            return this;
        }

        @Override
        public Builder<RequestT, ResponseT, PagedListResponseT> setRetrySettingsBuilder(RetrySettings.Builder retrySettingsBuilder) {
            super.setRetrySettingsBuilder(retrySettingsBuilder);
            return this;
        }

        @Override
        public PagedCallSettings<RequestT, ResponseT, PagedListResponseT> build() {
            return new PagedCallSettings(ImmutableSet.copyOf(this.getRetryableCodes()), this.getRetrySettingsBuilder().build(), this.getMethodDescriptor(), this.pagedListResponseFactory);
        }
    }
}

