/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.bundling;

import com.google.api.gax.bundling.BundlingThreshold;
import com.google.api.gax.bundling.ExternalThreshold;
import com.google.api.gax.bundling.ThresholdBundleHandle;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.Duration;

public final class ThresholdBundler<E> {
    private ImmutableList<BundlingThreshold<E>> thresholdPrototypes;
    private ImmutableList<ExternalThreshold<E>> externalThresholdPrototypes;
    private final Duration maxDelay;
    private final Lock lock = new ReentrantLock();
    private final Condition bundleCondition = this.lock.newCondition();
    private Bundle currentOpenBundle;
    private List<Bundle> closedBundles = new ArrayList<Bundle>();

    private ThresholdBundler(ImmutableList<BundlingThreshold<E>> thresholds, ImmutableList<ExternalThreshold<E>> externalThresholds, Duration maxDelay) {
        this.thresholdPrototypes = ThresholdBundler.copyResetThresholds((ImmutableList)Preconditions.checkNotNull(thresholds));
        this.externalThresholdPrototypes = ThresholdBundler.copyResetExternalThresholds((ImmutableList)Preconditions.checkNotNull(externalThresholds));
        this.maxDelay = maxDelay;
        this.currentOpenBundle = null;
    }

    public static <T> Builder<T> newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThresholdBundleHandle add(E e) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.validateLimits(e);
            boolean signalBundleIsReady = false;
            Bundle bundleOfAddedItem = null;
            if (this.currentOpenBundle == null) {
                this.currentOpenBundle = new Bundle(this.thresholdPrototypes, this.externalThresholdPrototypes, this.maxDelay);
                this.currentOpenBundle.start();
                signalBundleIsReady = true;
            }
            if (this.currentOpenBundle.canAccept(e)) {
                this.currentOpenBundle.add(e);
                bundleOfAddedItem = this.currentOpenBundle;
                if (this.currentOpenBundle.isAnyThresholdReached()) {
                    signalBundleIsReady = true;
                    this.closedBundles.add(this.currentOpenBundle);
                    this.currentOpenBundle = null;
                }
            } else {
                signalBundleIsReady = true;
                this.closedBundles.add(this.currentOpenBundle);
                this.currentOpenBundle = new Bundle(this.thresholdPrototypes, this.externalThresholdPrototypes, this.maxDelay);
                this.currentOpenBundle.start();
                this.currentOpenBundle.add(e);
                bundleOfAddedItem = this.currentOpenBundle;
            }
            if (signalBundleIsReady) {
                this.bundleCondition.signalAll();
            }
            Bundle bundle = bundleOfAddedItem;
            return bundle;
        }
        finally {
            lock.unlock();
        }
    }

    public void flush() {
        Lock lock = this.lock;
        lock.lock();
        try {
            if (this.currentOpenBundle != null) {
                this.closedBundles.add(this.currentOpenBundle);
                this.currentOpenBundle = null;
            }
            this.bundleCondition.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainNextBundleTo(Collection<? super E> outputCollection) {
        Lock lock = this.lock;
        lock.lock();
        try {
            Bundle outBundle = null;
            if (this.closedBundles.size() > 0) {
                outBundle = this.closedBundles.remove(0);
            } else if (this.currentOpenBundle != null) {
                outBundle = this.currentOpenBundle;
                this.currentOpenBundle = null;
            }
            if (outBundle != null) {
                outputCollection.addAll(outBundle.getData());
                int n = outputCollection.size();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> takeBundle() throws InterruptedException {
        Lock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.shouldWait()) {
                if (this.currentOpenBundle == null || this.maxDelay == null) {
                    this.bundleCondition.await();
                    continue;
                }
                this.bundleCondition.await(this.currentOpenBundle.getDelayLeft().getMillis(), TimeUnit.MILLISECONDS);
            }
            ArrayList bundle = new ArrayList();
            this.drainNextBundleTo(bundle);
            ArrayList arrayList = bundle;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isEmpty() {
        Lock lock = this.lock;
        lock.lock();
        try {
            if (this.closedBundles.size() > 0) {
                boolean bl = false;
                return bl;
            }
            if (this.currentOpenBundle != null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private void validateLimits(E e) {
        for (BundlingThreshold threshold : this.thresholdPrototypes) {
            if (threshold.canAccept(e)) continue;
            throw new IllegalArgumentException("Single item too large for bundle");
        }
    }

    private boolean shouldWait() {
        if (this.closedBundles.size() > 0) {
            return false;
        }
        if (this.currentOpenBundle == null) {
            return true;
        }
        if (this.maxDelay == null) {
            return true;
        }
        return this.currentOpenBundle.getDelayLeft().getMillis() > 0L;
    }

    private static <E> ImmutableList<BundlingThreshold<E>> copyResetThresholds(ImmutableList<BundlingThreshold<E>> thresholds) {
        ImmutableList.Builder resetThresholds = ImmutableList.builder();
        for (BundlingThreshold threshold : thresholds) {
            resetThresholds.add(threshold.copyWithZeroedValue());
        }
        return resetThresholds.build();
    }

    private static <E> ImmutableList<ExternalThreshold<E>> copyResetExternalThresholds(ImmutableList<ExternalThreshold<E>> thresholds) {
        ImmutableList.Builder resetThresholds = ImmutableList.builder();
        for (ExternalThreshold threshold : thresholds) {
            resetThresholds.add(threshold.copyWithZeroedValue());
        }
        return resetThresholds.build();
    }

    private class Bundle
    implements ThresholdBundleHandle {
        private final ImmutableList<BundlingThreshold<E>> thresholds;
        private final ImmutableList<ExternalThreshold<E>> externalThresholds;
        private final Duration maxDelay;
        private final List<E> data = new ArrayList();
        private Stopwatch stopwatch;

        private Bundle(ImmutableList<BundlingThreshold<E>> thresholds, ImmutableList<ExternalThreshold<E>> externalThresholds, Duration maxDelay) {
            this.thresholds = ThresholdBundler.copyResetThresholds(thresholds);
            this.externalThresholds = ThresholdBundler.copyResetExternalThresholds(externalThresholds);
            this.maxDelay = maxDelay;
        }

        private void start() {
            this.stopwatch = Stopwatch.createStarted();
            for (ExternalThreshold threshold : this.externalThresholds) {
                threshold.startBundle();
            }
        }

        private boolean canAccept(E e) {
            for (BundlingThreshold threshold : this.thresholds) {
                if (threshold.canAccept(e)) continue;
                return false;
            }
            return true;
        }

        private void add(E e) {
            this.data.add(e);
            for (BundlingThreshold threshold : this.thresholds) {
                threshold.accumulate(e);
            }
        }

        private List<E> getData() {
            return this.data;
        }

        private Duration getDelayLeft() {
            return Duration.millis((long)(this.maxDelay.getMillis() - this.stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        }

        private boolean isAnyThresholdReached() {
            for (BundlingThreshold threshold : this.thresholds) {
                if (!threshold.isThresholdReached()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void externalThresholdEvent(Object event) {
            Lock lock = ThresholdBundler.this.lock;
            lock.lock();
            try {
                for (ExternalThreshold threshold : this.externalThresholds) {
                    threshold.handleEvent(this, event);
                }
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void flush() {
            Lock lock = ThresholdBundler.this.lock;
            lock.lock();
            try {
                if (ThresholdBundler.this.currentOpenBundle != this) {
                    return;
                }
                ThresholdBundler.this.flush();
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static final class Builder<E> {
        private List<BundlingThreshold<E>> thresholds = Lists.newArrayList();
        private List<ExternalThreshold<E>> externalThresholds = Lists.newArrayList();
        private Duration maxDelay;

        private Builder() {
        }

        public Builder<E> setMaxDelay(Duration maxDelay) {
            this.maxDelay = maxDelay;
            return this;
        }

        public Builder<E> setThresholds(List<BundlingThreshold<E>> thresholds) {
            this.thresholds = thresholds;
            return this;
        }

        public Builder<E> addThreshold(BundlingThreshold<E> threshold) {
            this.thresholds.add(threshold);
            return this;
        }

        public Builder<E> setExternalThresholds(List<ExternalThreshold<E>> externalThresholds) {
            this.externalThresholds = externalThresholds;
            return this;
        }

        public Builder<E> addExternalThreshold(ExternalThreshold<E> externalThreshold) {
            this.externalThresholds.add(externalThreshold);
            return this;
        }

        public ThresholdBundler<E> build() {
            return new ThresholdBundler(ImmutableList.copyOf(this.thresholds), ImmutableList.copyOf(this.externalThresholds), this.maxDelay);
        }
    }
}

