/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.DescriptorClientCallFactory;
import com.google.api.gax.grpc.DirectCallable;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.collect.ImmutableSet;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.ScheduledExecutorService;

abstract class UnaryCallSettingsTyped<RequestT, ResponseT>
extends UnaryCallSettings {
    private final MethodDescriptor<RequestT, ResponseT> methodDescriptor;

    public MethodDescriptor<RequestT, ResponseT> getMethodDescriptor() {
        return this.methodDescriptor;
    }

    @Override
    public abstract Builder<RequestT, ResponseT> toBuilder();

    protected UnaryCallSettingsTyped(ImmutableSet<Status.Code> retryableCodes, RetrySettings retrySettings, MethodDescriptor<RequestT, ResponseT> methodDescriptor) {
        super(retryableCodes, retrySettings);
        this.methodDescriptor = methodDescriptor;
    }

    protected UnaryCallable<RequestT, ResponseT> createBaseCallable(Channel channel, ScheduledExecutorService executor) {
        DescriptorClientCallFactory<RequestT, ResponseT> clientCallFactory = new DescriptorClientCallFactory<RequestT, ResponseT>(this.methodDescriptor);
        UnaryCallable<RequestT, ResponseT> callable = new UnaryCallable<RequestT, ResponseT>(new DirectCallable<RequestT, ResponseT>(clientCallFactory), channel, this);
        if (this.getRetryableCodes() != null) {
            callable = callable.retryableOn((ImmutableSet<Status.Code>)ImmutableSet.copyOf(this.getRetryableCodes()));
        }
        if (this.getRetrySettings() != null) {
            callable = callable.retrying(this.getRetrySettings(), executor);
        }
        return callable;
    }

    public static abstract class Builder<RequestT, ResponseT>
    extends UnaryCallSettings.Builder {
        private MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor;

        protected Builder(MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor) {
            this.grpcMethodDescriptor = grpcMethodDescriptor;
        }

        protected Builder(UnaryCallSettingsTyped<RequestT, ResponseT> settings) {
            super(settings);
            this.grpcMethodDescriptor = settings.getMethodDescriptor();
        }

        public MethodDescriptor<RequestT, ResponseT> getMethodDescriptor() {
            return this.grpcMethodDescriptor;
        }

        @Override
        public abstract UnaryCallSettingsTyped<RequestT, ResponseT> build();
    }
}

