/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.HeaderInterceptor;
import com.google.auth.Credentials;
import com.google.common.collect.Lists;
import io.grpc.ManagedChannel;
import io.grpc.auth.ClientAuthInterceptor;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public final class InstantiatingChannelProvider
implements ChannelProvider {
    private static final String DEFAULT_GAX_VERSION = "0.0.26";
    private final ExecutorProvider executorProvider;
    private final CredentialsProvider credentialsProvider;
    private final String serviceAddress;
    private final int port;
    private final String clientLibName;
    private final String clientLibVersion;
    private final String serviceGeneratorName;
    private final String serviceGeneratorVersion;

    private InstantiatingChannelProvider(ExecutorProvider executorProvider, CredentialsProvider credentialsProvider, String serviceAddress, int port, String clientLibName, String clientLibVersion, String serviceGeneratorName, String serviceGeneratorVersion) {
        this.executorProvider = executorProvider;
        this.credentialsProvider = credentialsProvider;
        this.serviceAddress = serviceAddress;
        this.port = port;
        this.clientLibName = clientLibName;
        this.clientLibVersion = clientLibVersion;
        this.serviceGeneratorName = serviceGeneratorName;
        this.serviceGeneratorVersion = serviceGeneratorVersion;
    }

    @Override
    public boolean needsExecutor() {
        return this.executorProvider == null;
    }

    @Override
    public ManagedChannel getChannel() throws IOException {
        if (this.needsExecutor()) {
            throw new IllegalStateException("getChannel() called when needsExecutor() is true");
        }
        return this.createChannel(this.executorProvider.getExecutor());
    }

    @Override
    public ManagedChannel getChannel(Executor executor) throws IOException {
        if (!this.needsExecutor()) {
            throw new IllegalStateException("getChannel(Executor) called when needsExecutor() is false");
        }
        return this.createChannel(executor);
    }

    private ManagedChannel createChannel(Executor executor) throws IOException {
        ArrayList interceptors = Lists.newArrayList();
        interceptors.add(new ClientAuthInterceptor(this.credentialsProvider.getCredentials(), executor));
        interceptors.add(new HeaderInterceptor(this.serviceHeader()));
        return ((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)this.serviceAddress, (int)this.port).negotiationType(NegotiationType.TLS).intercept((List)interceptors)).executor(executor)).build();
    }

    public Credentials getCredentials() throws IOException {
        return this.getCredentialsProvider().getCredentials();
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public boolean shouldAutoClose() {
        return true;
    }

    private String serviceHeader() {
        String gaxVersion = ChannelProvider.class.getPackage().getImplementationVersion();
        if (gaxVersion == null) {
            gaxVersion = DEFAULT_GAX_VERSION;
        }
        String javaVersion = Runtime.class.getPackage().getImplementationVersion();
        return String.format("%s/%s %s/%s gax/%s java/%s", this.clientLibName, this.clientLibVersion, this.serviceGeneratorName, this.serviceGeneratorVersion, gaxVersion, javaVersion);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private static final String DEFAULT_GENERATOR_NAME = "gapic";
        private static final String DEFAULT_CLIENT_LIB_NAME = "gax";
        private static final String DEFAULT_GEN_VERSION = "0.1.0";
        private ExecutorProvider executorProvider;
        private CredentialsProvider credentialsProvider;
        private String serviceAddress;
        private int port;
        private String clientLibName;
        private String clientLibVersion;
        private String serviceGeneratorName;
        private String serviceGeneratorVersion;

        private Builder() {
            this.clientLibName = DEFAULT_CLIENT_LIB_NAME;
            this.clientLibVersion = InstantiatingChannelProvider.DEFAULT_GAX_VERSION;
            this.serviceGeneratorName = DEFAULT_GENERATOR_NAME;
            this.serviceGeneratorVersion = DEFAULT_GEN_VERSION;
        }

        private Builder(InstantiatingChannelProvider provider) {
            this.credentialsProvider = provider.credentialsProvider;
            this.serviceAddress = provider.serviceAddress;
            this.port = provider.port;
            this.clientLibName = provider.clientLibName;
            this.clientLibVersion = provider.clientLibVersion;
            this.serviceGeneratorName = provider.serviceGeneratorName;
            this.serviceGeneratorVersion = provider.serviceGeneratorVersion;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        public Builder setServiceAddress(String serviceAddress) {
            this.serviceAddress = serviceAddress;
            return this;
        }

        public String getServiceAddress() {
            return this.serviceAddress;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Builder setGeneratorHeader(String name, String version) {
            this.serviceGeneratorName = name;
            this.serviceGeneratorVersion = version;
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            this.clientLibName = name;
            this.clientLibVersion = version;
            return this;
        }

        public String getClientLibName() {
            return this.clientLibName;
        }

        public String getClientLibVersion() {
            return this.clientLibVersion;
        }

        public String getGeneratorName() {
            return this.serviceGeneratorName;
        }

        public String getGeneratorVersion() {
            return this.serviceGeneratorVersion;
        }

        public InstantiatingChannelProvider build() {
            return new InstantiatingChannelProvider(this.executorProvider, this.credentialsProvider, this.serviceAddress, this.port, this.clientLibName, this.clientLibVersion, this.serviceGeneratorName, this.serviceGeneratorVersion);
        }
    }
}

