/*
 * Decompiled with CFR 0.152.
 */
package com.google.longrunning;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.DeleteOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.ListOperationsRequest;
import com.google.longrunning.ListOperationsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsSettings;
import com.google.longrunning.PagedResponseWrappers;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class OperationsClient
implements AutoCloseable {
    private final OperationsSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<GetOperationRequest, Operation> getOperationCallable;
    private final UnaryCallable<ListOperationsRequest, ListOperationsResponse> listOperationsCallable;
    private final UnaryCallable<ListOperationsRequest, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsPagedCallable;
    private final UnaryCallable<CancelOperationRequest, Empty> cancelOperationCallable;
    private final UnaryCallable<DeleteOperationRequest, Empty> deleteOperationCallable;
    private static final PathTemplate OPERATION_PATH_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding("operations/{operation_path=**}");

    public static final String formatOperationPathName(String operationPath) {
        return OPERATION_PATH_PATH_TEMPLATE.instantiate("operation_path", operationPath);
    }

    public static final String parseOperationPathFromOperationPathName(String operationPathName) {
        return OPERATION_PATH_PATH_TEMPLATE.parse(operationPathName).get("operation_path");
    }

    public static final OperationsClient create(OperationsSettings settings) throws IOException {
        return new OperationsClient(settings);
    }

    protected OperationsClient(OperationsSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.getOperationCallable = UnaryCallable.create(settings.getOperationSettings(), (Channel)this.channel, this.executor);
        this.listOperationsCallable = UnaryCallable.create(settings.listOperationsSettings(), (Channel)this.channel, this.executor);
        this.listOperationsPagedCallable = UnaryCallable.createPagedVariant(settings.listOperationsSettings(), (Channel)this.channel, this.executor);
        this.cancelOperationCallable = UnaryCallable.create(settings.cancelOperationSettings(), (Channel)this.channel, this.executor);
        this.deleteOperationCallable = UnaryCallable.create(settings.deleteOperationSettings(), (Channel)this.channel, this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    OperationsClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    OperationsClient.this.executor.shutdown();
                }
            });
        }
    }

    public final OperationsSettings getSettings() {
        return this.settings;
    }

    public final Operation getOperation(String name) {
        OPERATION_PATH_PATH_TEMPLATE.validate(name, "getOperation");
        GetOperationRequest request = GetOperationRequest.newBuilder().setName(name).build();
        return this.getOperation(request);
    }

    private final Operation getOperation(GetOperationRequest request) {
        return this.getOperationCallable().call(request);
    }

    public final UnaryCallable<GetOperationRequest, Operation> getOperationCallable() {
        return this.getOperationCallable;
    }

    public final PagedResponseWrappers.ListOperationsPagedResponse listOperations(String name, String filter) {
        ListOperationsRequest request = ListOperationsRequest.newBuilder().setName(name).setFilter(filter).build();
        return this.listOperations(request);
    }

    public final PagedResponseWrappers.ListOperationsPagedResponse listOperations(ListOperationsRequest request) {
        return this.listOperationsPagedCallable().call(request);
    }

    public final UnaryCallable<ListOperationsRequest, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsPagedCallable() {
        return this.listOperationsPagedCallable;
    }

    public final UnaryCallable<ListOperationsRequest, ListOperationsResponse> listOperationsCallable() {
        return this.listOperationsCallable;
    }

    public final void cancelOperation(String name) {
        OPERATION_PATH_PATH_TEMPLATE.validate(name, "cancelOperation");
        CancelOperationRequest request = CancelOperationRequest.newBuilder().setName(name).build();
        this.cancelOperation(request);
    }

    private final void cancelOperation(CancelOperationRequest request) {
        this.cancelOperationCallable().call(request);
    }

    public final UnaryCallable<CancelOperationRequest, Empty> cancelOperationCallable() {
        return this.cancelOperationCallable;
    }

    public final void deleteOperation(String name) {
        OPERATION_PATH_PATH_TEMPLATE.validate(name, "deleteOperation");
        DeleteOperationRequest request = DeleteOperationRequest.newBuilder().setName(name).build();
        this.deleteOperation(request);
    }

    private final void deleteOperation(DeleteOperationRequest request) {
        this.deleteOperationCallable().call(request);
    }

    public final UnaryCallable<DeleteOperationRequest, Empty> deleteOperationCallable() {
        return this.deleteOperationCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

