/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.DirectStreamingCallable;
import com.google.api.gax.grpc.StreamingCallSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;

public class StreamingCallable<RequestT, ResponseT> {
    private final DirectStreamingCallable<RequestT, ResponseT> callable;
    private ManagedChannel channel;

    StreamingCallable(DirectStreamingCallable<RequestT, ResponseT> callable) {
        this.callable = callable;
    }

    public void bind(ManagedChannel channel) {
        this.channel = channel;
    }

    public static <RequestT, ResponseT> StreamingCallable<RequestT, ResponseT> create(StreamingCallSettings<RequestT, ResponseT> streamingCallSettings, ManagedChannel channel) {
        return streamingCallSettings.createStreamingCallable(channel);
    }

    public StreamObserver<RequestT> bidiStreamingCall(StreamObserver<ResponseT> responseObserver) {
        Preconditions.checkNotNull((Object)this.channel);
        return this.callable.bidiStreamingCall(responseObserver, CallContext.createDefault().withChannel((Channel)this.channel));
    }

    public StreamObserver<RequestT> bidiStreamingCall(StreamObserver<ResponseT> responseObserver, CallContext context) {
        if (context.getChannel() == null) {
            context = context.withChannel((Channel)this.channel);
        }
        Preconditions.checkNotNull((Object)context.getChannel());
        return this.callable.bidiStreamingCall(responseObserver, context);
    }

    public void serverStreamingCall(RequestT request, StreamObserver<ResponseT> responseObserver) {
        Preconditions.checkNotNull((Object)this.channel);
        this.callable.serverStreamingCall(request, responseObserver, CallContext.createDefault().withChannel((Channel)this.channel));
    }

    public void serverStreamingCall(RequestT request, StreamObserver<ResponseT> responseObserver, CallContext context) {
        if (context.getChannel() == null) {
            context = context.withChannel((Channel)this.channel);
        }
        Preconditions.checkNotNull((Object)context.getChannel());
        this.callable.serverStreamingCall(request, responseObserver, context);
    }

    public Iterator<ResponseT> serverStreamingCall(RequestT request) {
        Preconditions.checkNotNull((Object)this.channel);
        return this.callable.blockingServerStreamingCall(request, CallContext.createDefault().withChannel((Channel)this.channel));
    }

    public Iterator<ResponseT> serverStreamingCall(RequestT request, CallContext context) {
        if (context.getChannel() == null) {
            context = context.withChannel((Channel)this.channel);
        }
        return this.callable.blockingServerStreamingCall(request, context);
    }

    public StreamObserver<RequestT> clientStreamingCall(StreamObserver<ResponseT> responseObserver) {
        Preconditions.checkNotNull((Object)this.channel);
        return this.callable.clientStreamingCall(responseObserver, CallContext.createDefault().withChannel((Channel)this.channel));
    }

    public StreamObserver<RequestT> clientStreamingCall(StreamObserver<ResponseT> responseObserver, CallContext context) {
        if (context.getChannel() == null) {
            context = context.withChannel((Channel)this.channel);
        }
        return this.callable.clientStreamingCall(responseObserver, context);
    }

    @VisibleForTesting
    ManagedChannel getChannel() {
        return this.channel;
    }
}

