/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.BundlerFactory;
import com.google.api.gax.grpc.BundlingDescriptor;
import com.google.api.gax.grpc.BundlingSettings;
import com.google.api.gax.grpc.UnaryCallSettingsTyped;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;

public final class BundlingCallSettings<RequestT, ResponseT>
extends UnaryCallSettingsTyped<RequestT, ResponseT> {
    private final BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor;
    private final BundlingSettings bundlingSettings;
    private BundlerFactory<RequestT, ResponseT> bundlerFactory;

    UnaryCallable<RequestT, ResponseT> create(ManagedChannel channel, ScheduledExecutorService executor) {
        UnaryCallable<RequestT, ResponseT> baseCallable = this.createBaseCallable(channel, executor);
        this.bundlerFactory = new BundlerFactory<RequestT, ResponseT>(this.bundlingDescriptor, this.bundlingSettings);
        return baseCallable.bundling(this.bundlingDescriptor, this.bundlerFactory);
    }

    public BundlerFactory<RequestT, ResponseT> getBundlerFactory() {
        return this.bundlerFactory;
    }

    private BundlingCallSettings(ImmutableSet<Status.Code> retryableCodes, RetrySettings retrySettings, MethodDescriptor<RequestT, ResponseT> methodDescriptor, BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor, BundlingSettings bundlingSettings) {
        super(retryableCodes, retrySettings, methodDescriptor);
        this.bundlingDescriptor = bundlingDescriptor;
        this.bundlingSettings = bundlingSettings;
    }

    public static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder(MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor, BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor) {
        return new Builder<RequestT, ResponseT>(grpcMethodDescriptor, bundlingDescriptor);
    }

    @Override
    public final Builder<RequestT, ResponseT> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<RequestT, ResponseT>
    extends UnaryCallSettingsTyped.Builder<RequestT, ResponseT> {
        private BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor;
        private BundlingSettings.Builder bundlingSettingsBuilder;

        public Builder(MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor, BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor) {
            super(grpcMethodDescriptor);
            this.bundlingDescriptor = bundlingDescriptor;
            this.bundlingSettingsBuilder = BundlingSettings.newBuilder();
        }

        public Builder(BundlingCallSettings<RequestT, ResponseT> settings) {
            super(settings);
            this.bundlingDescriptor = ((BundlingCallSettings)settings).bundlingDescriptor;
            this.bundlingSettingsBuilder = ((BundlingCallSettings)settings).bundlingSettings.toBuilder();
        }

        public BundlingDescriptor<RequestT, ResponseT> getBundlingDescriptor() {
            return this.bundlingDescriptor;
        }

        public Builder<RequestT, ResponseT> setBundlingSettingsBuilder(BundlingSettings.Builder bundlingSettingsBuilder) {
            this.bundlingSettingsBuilder = (BundlingSettings.Builder)Preconditions.checkNotNull((Object)bundlingSettingsBuilder);
            return this;
        }

        public BundlingSettings.Builder getBundlingSettingsBuilder() {
            return this.bundlingSettingsBuilder;
        }

        @Override
        public Builder<RequestT, ResponseT> setRetryableCodes(Set<Status.Code> retryableCodes) {
            super.setRetryableCodes(retryableCodes);
            return this;
        }

        @Override
        public Builder<RequestT, ResponseT> setRetryableCodes(Status.Code ... codes) {
            super.setRetryableCodes(codes);
            return this;
        }

        @Override
        public Builder<RequestT, ResponseT> setRetrySettingsBuilder(RetrySettings.Builder retrySettingsBuilder) {
            super.setRetrySettingsBuilder(retrySettingsBuilder);
            return this;
        }

        @Override
        public BundlingCallSettings<RequestT, ResponseT> build() {
            return new BundlingCallSettings(ImmutableSet.copyOf(this.getRetryableCodes()), this.getRetrySettingsBuilder().build(), this.getMethodDescriptor(), this.bundlingDescriptor, this.bundlingSettingsBuilder.build());
        }
    }
}

