
package com.google.api.gax.core;

import javax.annotation.Generated;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_RetrySettings extends RetrySettings {

  private final Duration totalTimeout;
  private final Duration initialRetryDelay;
  private final double retryDelayMultiplier;
  private final Duration maxRetryDelay;
  private final Duration initialRpcTimeout;
  private final double rpcTimeoutMultiplier;
  private final Duration maxRpcTimeout;

  private AutoValue_RetrySettings(
      Duration totalTimeout,
      Duration initialRetryDelay,
      double retryDelayMultiplier,
      Duration maxRetryDelay,
      Duration initialRpcTimeout,
      double rpcTimeoutMultiplier,
      Duration maxRpcTimeout) {
    if (totalTimeout == null) {
      throw new NullPointerException("Null totalTimeout");
    }
    this.totalTimeout = totalTimeout;
    if (initialRetryDelay == null) {
      throw new NullPointerException("Null initialRetryDelay");
    }
    this.initialRetryDelay = initialRetryDelay;
    this.retryDelayMultiplier = retryDelayMultiplier;
    if (maxRetryDelay == null) {
      throw new NullPointerException("Null maxRetryDelay");
    }
    this.maxRetryDelay = maxRetryDelay;
    if (initialRpcTimeout == null) {
      throw new NullPointerException("Null initialRpcTimeout");
    }
    this.initialRpcTimeout = initialRpcTimeout;
    this.rpcTimeoutMultiplier = rpcTimeoutMultiplier;
    if (maxRpcTimeout == null) {
      throw new NullPointerException("Null maxRpcTimeout");
    }
    this.maxRpcTimeout = maxRpcTimeout;
  }

  @Override
  public Duration getTotalTimeout() {
    return totalTimeout;
  }

  @Override
  public Duration getInitialRetryDelay() {
    return initialRetryDelay;
  }

  @Override
  public double getRetryDelayMultiplier() {
    return retryDelayMultiplier;
  }

  @Override
  public Duration getMaxRetryDelay() {
    return maxRetryDelay;
  }

  @Override
  public Duration getInitialRpcTimeout() {
    return initialRpcTimeout;
  }

  @Override
  public double getRpcTimeoutMultiplier() {
    return rpcTimeoutMultiplier;
  }

  @Override
  public Duration getMaxRpcTimeout() {
    return maxRpcTimeout;
  }

  @Override
  public String toString() {
    return "RetrySettings{"
        + "totalTimeout=" + totalTimeout + ", "
        + "initialRetryDelay=" + initialRetryDelay + ", "
        + "retryDelayMultiplier=" + retryDelayMultiplier + ", "
        + "maxRetryDelay=" + maxRetryDelay + ", "
        + "initialRpcTimeout=" + initialRpcTimeout + ", "
        + "rpcTimeoutMultiplier=" + rpcTimeoutMultiplier + ", "
        + "maxRpcTimeout=" + maxRpcTimeout
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RetrySettings) {
      RetrySettings that = (RetrySettings) o;
      return (this.totalTimeout.equals(that.getTotalTimeout()))
           && (this.initialRetryDelay.equals(that.getInitialRetryDelay()))
           && (Double.doubleToLongBits(this.retryDelayMultiplier) == Double.doubleToLongBits(that.getRetryDelayMultiplier()))
           && (this.maxRetryDelay.equals(that.getMaxRetryDelay()))
           && (this.initialRpcTimeout.equals(that.getInitialRpcTimeout()))
           && (Double.doubleToLongBits(this.rpcTimeoutMultiplier) == Double.doubleToLongBits(that.getRpcTimeoutMultiplier()))
           && (this.maxRpcTimeout.equals(that.getMaxRpcTimeout()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.totalTimeout.hashCode();
    h *= 1000003;
    h ^= this.initialRetryDelay.hashCode();
    h *= 1000003;
    h ^= (Double.doubleToLongBits(this.retryDelayMultiplier) >>> 32) ^ Double.doubleToLongBits(this.retryDelayMultiplier);
    h *= 1000003;
    h ^= this.maxRetryDelay.hashCode();
    h *= 1000003;
    h ^= this.initialRpcTimeout.hashCode();
    h *= 1000003;
    h ^= (Double.doubleToLongBits(this.rpcTimeoutMultiplier) >>> 32) ^ Double.doubleToLongBits(this.rpcTimeoutMultiplier);
    h *= 1000003;
    h ^= this.maxRpcTimeout.hashCode();
    return h;
  }

  static final class Builder extends RetrySettings.Builder {
    private Duration totalTimeout;
    private Duration initialRetryDelay;
    private Double retryDelayMultiplier;
    private Duration maxRetryDelay;
    private Duration initialRpcTimeout;
    private Double rpcTimeoutMultiplier;
    private Duration maxRpcTimeout;
    Builder() {
    }
    Builder(RetrySettings source) {
      this.totalTimeout = source.getTotalTimeout();
      this.initialRetryDelay = source.getInitialRetryDelay();
      this.retryDelayMultiplier = source.getRetryDelayMultiplier();
      this.maxRetryDelay = source.getMaxRetryDelay();
      this.initialRpcTimeout = source.getInitialRpcTimeout();
      this.rpcTimeoutMultiplier = source.getRpcTimeoutMultiplier();
      this.maxRpcTimeout = source.getMaxRpcTimeout();
    }
    @Override
    public RetrySettings.Builder setTotalTimeout(Duration totalTimeout) {
      this.totalTimeout = totalTimeout;
      return this;
    }
    @Override
    public Duration getTotalTimeout() {
      if (totalTimeout == null) {
        throw new IllegalStateException("Property \"totalTimeout\" has not been set");
      }
      return totalTimeout;
    }
    @Override
    public RetrySettings.Builder setInitialRetryDelay(Duration initialRetryDelay) {
      this.initialRetryDelay = initialRetryDelay;
      return this;
    }
    @Override
    public Duration getInitialRetryDelay() {
      if (initialRetryDelay == null) {
        throw new IllegalStateException("Property \"initialRetryDelay\" has not been set");
      }
      return initialRetryDelay;
    }
    @Override
    public RetrySettings.Builder setRetryDelayMultiplier(double retryDelayMultiplier) {
      this.retryDelayMultiplier = retryDelayMultiplier;
      return this;
    }
    @Override
    public double getRetryDelayMultiplier() {
      if (retryDelayMultiplier == null) {
        throw new IllegalStateException("Property \"retryDelayMultiplier\" has not been set");
      }
      return retryDelayMultiplier;
    }
    @Override
    public RetrySettings.Builder setMaxRetryDelay(Duration maxRetryDelay) {
      this.maxRetryDelay = maxRetryDelay;
      return this;
    }
    @Override
    public Duration getMaxRetryDelay() {
      if (maxRetryDelay == null) {
        throw new IllegalStateException("Property \"maxRetryDelay\" has not been set");
      }
      return maxRetryDelay;
    }
    @Override
    public RetrySettings.Builder setInitialRpcTimeout(Duration initialRpcTimeout) {
      this.initialRpcTimeout = initialRpcTimeout;
      return this;
    }
    @Override
    public Duration getInitialRpcTimeout() {
      if (initialRpcTimeout == null) {
        throw new IllegalStateException("Property \"initialRpcTimeout\" has not been set");
      }
      return initialRpcTimeout;
    }
    @Override
    public RetrySettings.Builder setRpcTimeoutMultiplier(double rpcTimeoutMultiplier) {
      this.rpcTimeoutMultiplier = rpcTimeoutMultiplier;
      return this;
    }
    @Override
    public double getRpcTimeoutMultiplier() {
      if (rpcTimeoutMultiplier == null) {
        throw new IllegalStateException("Property \"rpcTimeoutMultiplier\" has not been set");
      }
      return rpcTimeoutMultiplier;
    }
    @Override
    public RetrySettings.Builder setMaxRpcTimeout(Duration maxRpcTimeout) {
      this.maxRpcTimeout = maxRpcTimeout;
      return this;
    }
    @Override
    public Duration getMaxRpcTimeout() {
      if (maxRpcTimeout == null) {
        throw new IllegalStateException("Property \"maxRpcTimeout\" has not been set");
      }
      return maxRpcTimeout;
    }
    @Override
    public RetrySettings autoBuild() {
      String missing = "";
      if (totalTimeout == null) {
        missing += " totalTimeout";
      }
      if (initialRetryDelay == null) {
        missing += " initialRetryDelay";
      }
      if (retryDelayMultiplier == null) {
        missing += " retryDelayMultiplier";
      }
      if (maxRetryDelay == null) {
        missing += " maxRetryDelay";
      }
      if (initialRpcTimeout == null) {
        missing += " initialRpcTimeout";
      }
      if (rpcTimeoutMultiplier == null) {
        missing += " rpcTimeoutMultiplier";
      }
      if (maxRpcTimeout == null) {
        missing += " maxRpcTimeout";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_RetrySettings(
          this.totalTimeout,
          this.initialRetryDelay,
          this.retryDelayMultiplier,
          this.maxRetryDelay,
          this.initialRpcTimeout,
          this.rpcTimeoutMultiplier,
          this.maxRpcTimeout);
    }
  }

}
