/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ClientCallFactory;
import com.google.api.gax.grpc.FutureCallable;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.stub.ClientCalls;

class DirectCallable<RequestT, ResponseT>
implements FutureCallable<RequestT, ResponseT> {
    private final ClientCallFactory<RequestT, ResponseT> factory;

    DirectCallable(ClientCallFactory<RequestT, ResponseT> factory) {
        Preconditions.checkNotNull(factory);
        this.factory = factory;
    }

    @Override
    public ListenableFuture<ResponseT> futureCall(RequestT request, CallContext context) {
        Preconditions.checkNotNull(request);
        return ClientCalls.futureUnaryCall(this.factory.newCall(context.getChannel(), context.getCallOptions()), request);
    }

    public String toString() {
        return String.format("direct(%s)", this.factory);
    }
}

