/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.AutoValue_ConnectionSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class ConnectionSettings {
    public Credentials getCredentials() throws IOException {
        return this.getCredentialsProvider().getCredentials();
    }

    public abstract CredentialsProvider getCredentialsProvider();

    public abstract String getServiceAddress();

    public abstract int getPort();

    public static Builder newBuilder() {
        return new AutoValue_ConnectionSettings.Builder();
    }

    public Builder toBuilder() {
        return new AutoValue_ConnectionSettings.Builder(this);
    }

    public static abstract class Builder {
        public abstract Builder setCredentialsProvider(CredentialsProvider var1);

        public Builder provideCredentialsWith(final Credentials credentials) {
            return this.setCredentialsProvider(new CredentialsProvider(){

                @Override
                public Credentials getCredentials() {
                    return credentials;
                }
            });
        }

        public Builder provideCredentialsWith(List<String> scopes) {
            final ArrayList scopesToApply = Lists.newArrayList(scopes);
            return this.setCredentialsProvider(new CredentialsProvider(){

                @Override
                public Credentials getCredentials() throws IOException {
                    GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
                    if (credentials.createScopedRequired()) {
                        credentials = credentials.createScoped((Collection)scopesToApply);
                    }
                    return credentials;
                }
            });
        }

        public abstract Builder setServiceAddress(String var1);

        public abstract Builder setPort(int var1);

        public abstract ConnectionSettings build();
    }
}

