
package com.google.api.gax.core;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_BackoffParams extends BackoffParams {

  private final long initialDelayMillis;
  private final double delayMultiplier;
  private final long maxDelayMillis;

  private AutoValue_BackoffParams(
      long initialDelayMillis,
      double delayMultiplier,
      long maxDelayMillis) {
    this.initialDelayMillis = initialDelayMillis;
    this.delayMultiplier = delayMultiplier;
    this.maxDelayMillis = maxDelayMillis;
  }

  @Override
  public long getInitialDelayMillis() {
    return initialDelayMillis;
  }

  @Override
  public double getDelayMultiplier() {
    return delayMultiplier;
  }

  @Override
  public long getMaxDelayMillis() {
    return maxDelayMillis;
  }

  @Override
  public String toString() {
    return "BackoffParams{"
        + "initialDelayMillis=" + initialDelayMillis + ", "
        + "delayMultiplier=" + delayMultiplier + ", "
        + "maxDelayMillis=" + maxDelayMillis
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BackoffParams) {
      BackoffParams that = (BackoffParams) o;
      return (this.initialDelayMillis == that.getInitialDelayMillis())
           && (Double.doubleToLongBits(this.delayMultiplier) == Double.doubleToLongBits(that.getDelayMultiplier()))
           && (this.maxDelayMillis == that.getMaxDelayMillis());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (initialDelayMillis >>> 32) ^ initialDelayMillis;
    h *= 1000003;
    h ^= (Double.doubleToLongBits(delayMultiplier) >>> 32) ^ Double.doubleToLongBits(delayMultiplier);
    h *= 1000003;
    h ^= (maxDelayMillis >>> 32) ^ maxDelayMillis;
    return h;
  }

  static final class Builder extends BackoffParams.Builder {
    private Long initialDelayMillis;
    private Double delayMultiplier;
    private Long maxDelayMillis;
    Builder() {
    }
    Builder(BackoffParams source) {
      this.initialDelayMillis = source.getInitialDelayMillis();
      this.delayMultiplier = source.getDelayMultiplier();
      this.maxDelayMillis = source.getMaxDelayMillis();
    }
    @Override
    public BackoffParams.Builder setInitialDelayMillis(long initialDelayMillis) {
      this.initialDelayMillis = initialDelayMillis;
      return this;
    }
    @Override
    public BackoffParams.Builder setDelayMultiplier(double delayMultiplier) {
      this.delayMultiplier = delayMultiplier;
      return this;
    }
    @Override
    public BackoffParams.Builder setMaxDelayMillis(long maxDelayMillis) {
      this.maxDelayMillis = maxDelayMillis;
      return this;
    }
    @Override
    public BackoffParams autoBuild() {
      String missing = "";
      if (initialDelayMillis == null) {
        missing += " initialDelayMillis";
      }
      if (delayMultiplier == null) {
        missing += " delayMultiplier";
      }
      if (maxDelayMillis == null) {
        missing += " maxDelayMillis";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BackoffParams(
          this.initialDelayMillis,
          this.delayMultiplier,
          this.maxDelayMillis);
    }
  }
}
