/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.httpjson.HttpJsonStatusCode;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.StatusCode;

@BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
@InternalApi
public class HttpJsonOperationSnapshot
implements OperationSnapshot {
    private final String name;
    private final Object metadata;
    private final boolean done;
    private final Object response;
    private final StatusCode errorCode;
    private final String errorMessage;

    public HttpJsonOperationSnapshot(String name, Object metadata, boolean done, Object response, int errorCode, String errorMessage) {
        this.name = name;
        this.metadata = metadata;
        this.done = done;
        Object object = this.response = done ? response : null;
        if (done && errorCode != 0) {
            this.errorCode = HttpJsonStatusCode.of(errorCode, errorMessage);
            this.errorMessage = errorMessage;
        } else {
            this.errorCode = null;
            this.errorMessage = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public boolean isDone() {
        return this.done;
    }

    public Object getResponse() {
        return this.response;
    }

    public StatusCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private Object metadata;
        private boolean done;
        private Object response;
        private int errorCode;
        private String errorMessage;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setMetadata(Object metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setDone(boolean done) {
            this.done = done;
            return this;
        }

        public Builder setResponse(Object response) {
            this.response = response;
            return this;
        }

        public Builder setError(int errorCode, String errorMessage) {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
            return this;
        }

        public HttpJsonOperationSnapshot build() {
            return new HttpJsonOperationSnapshot(this.name, this.metadata, this.done, this.response, this.errorCode, this.errorMessage);
        }
    }
}

