/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.httpjson.HttpJsonChannel;
import com.google.api.gax.httpjson.HttpJsonHeaderEnhancer;
import com.google.api.gax.httpjson.HttpRequestRunnable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@BetaApi
public class ManagedHttpJsonChannel
implements HttpJsonChannel,
BackgroundResource {
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private final Executor executor;
    private final String endpoint;
    private final JsonFactory jsonFactory;
    private final ImmutableList<HttpJsonHeaderEnhancer> headerEnhancers;
    private final HttpTransport httpTransport;
    private boolean isTransportShutdown;

    private ManagedHttpJsonChannel(Executor executor, String endpoint, JsonFactory jsonFactory, List<HttpJsonHeaderEnhancer> headerEnhancers, @Nullable HttpTransport httpTransport) {
        this.executor = executor;
        this.endpoint = endpoint;
        this.jsonFactory = jsonFactory;
        this.headerEnhancers = ImmutableList.copyOf(headerEnhancers);
        this.httpTransport = httpTransport == null ? new NetHttpTransport() : httpTransport;
    }

    @Override
    public <ResponseT, RequestT> ApiFuture<ResponseT> issueFutureUnaryCall(HttpJsonCallOptions callOptions, RequestT request, ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor) {
        SettableApiFuture responseFuture = SettableApiFuture.create();
        HttpRequestRunnable runnable = HttpRequestRunnable.newBuilder().setApiFuture(responseFuture).setApiMethodDescriptor(methodDescriptor).setHeaderEnhancers((List<HttpJsonHeaderEnhancer>)this.headerEnhancers).setHttpJsonCallOptions(callOptions).setHttpTransport(this.httpTransport).setJsonFactory(this.jsonFactory).setRequest(request).setEndpoint(this.endpoint).build();
        this.executor.execute(runnable);
        return responseFuture;
    }

    public synchronized void shutdown() {
        if (this.isTransportShutdown) {
            return;
        }
        try {
            this.httpTransport.shutdown();
            this.isTransportShutdown = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isShutdown() {
        return this.isTransportShutdown;
    }

    public boolean isTerminated() {
        return this.isTransportShutdown;
    }

    public void shutdownNow() {
        this.shutdown();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return false;
    }

    public void close() throws Exception {
    }

    public static Builder newBuilder() {
        return new Builder().setHeaderEnhancers(new LinkedList<HttpJsonHeaderEnhancer>());
    }

    static /* synthetic */ JsonFactory access$100() {
        return JSON_FACTORY;
    }

    public static class Builder {
        private Executor executor;
        private String endpoint;
        private JsonFactory jsonFactory = ManagedHttpJsonChannel.access$100();
        private List<HttpJsonHeaderEnhancer> headerEnhancers;
        private HttpTransport httpTransport;

        private Builder() {
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setHeaderEnhancers(List<HttpJsonHeaderEnhancer> headerEnhancers) {
            this.headerEnhancers = headerEnhancers;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public ManagedHttpJsonChannel build() {
            Preconditions.checkNotNull((Object)this.executor);
            Preconditions.checkNotNull((Object)this.endpoint);
            return new ManagedHttpJsonChannel(this.executor, this.endpoint, this.jsonFactory, this.headerEnhancers, this.httpTransport);
        }
    }
}

