/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.ObjectParser;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.httpjson.HttpJsonHeaderEnhancer;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.pathtemplate.PathTemplate;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class HttpRequestRunnable<RequestT, ResponseT>
implements Runnable {
    private final HttpJsonCallOptions callOptions;
    private final RequestT request;
    private final ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor;
    private final HttpTransport httpTransport;
    private final String endpoint;
    private final JsonFactory jsonFactory;
    private final ImmutableList<HttpJsonHeaderEnhancer> headerEnhancers;
    private final SettableApiFuture<ResponseT> responseFuture;

    private HttpRequestRunnable(HttpJsonCallOptions callOptions, RequestT request, ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor, HttpTransport httpTransport, String endpoint, JsonFactory jsonFactory, List<HttpJsonHeaderEnhancer> headerEnhancers, SettableApiFuture<ResponseT> responseFuture) {
        this.endpoint = endpoint;
        this.jsonFactory = jsonFactory;
        this.headerEnhancers = ImmutableList.copyOf(headerEnhancers);
        this.callOptions = callOptions;
        this.request = request;
        this.methodDescriptor = methodDescriptor;
        this.httpTransport = httpTransport;
        this.responseFuture = responseFuture;
    }

    @Override
    public void run() {
        try (StringWriter stringWriter = new StringWriter();){
            GenericData tokenRequest = new GenericData();
            GoogleCredentials credentials = (GoogleCredentials)this.callOptions.getCredentials();
            HttpRequestFactory requestFactory = credentials != null ? this.httpTransport.createRequestFactory((HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials)) : this.httpTransport.createRequestFactory();
            HttpRequestFormatter<RequestT> requestBuilder = this.methodDescriptor.getHttpRequestBuilder();
            this.methodDescriptor.writeRequestBody(this.request, stringWriter);
            ((Writer)stringWriter).close();
            JsonHttpContent jsonHttpContent = null;
            if (!Strings.isNullOrEmpty((String)((Object)stringWriter).toString())) {
                this.jsonFactory.createJsonParser(((Object)stringWriter).toString()).parse((Object)tokenRequest);
                jsonHttpContent = new JsonHttpContent(this.jsonFactory, (Object)tokenRequest).setMediaType(new HttpMediaType("application/json"));
            }
            Map<String, String> pathParams = requestBuilder.getPathParams(this.request, this.methodDescriptor.getPathParams());
            PathTemplate pathPattern = PathTemplate.create((String)this.methodDescriptor.endpointPathTemplate());
            String relativePath = pathPattern.instantiate(pathParams);
            GenericUrl url = new GenericUrl(this.endpoint + relativePath);
            Map<String, List<String>> queryParams = requestBuilder.getQueryParams(this.request, this.methodDescriptor.getQueryParams());
            for (String queryParam : this.methodDescriptor.getQueryParams()) {
                if (!queryParams.containsKey(queryParam) || queryParams.get(queryParam) == null) continue;
                url.set(queryParam, queryParams.get(queryParam));
            }
            HttpRequest httpRequest = requestFactory.buildRequest(this.methodDescriptor.getHttpMethod(), url, (HttpContent)jsonHttpContent);
            for (HttpJsonHeaderEnhancer enhancer : this.headerEnhancers) {
                enhancer.enhance(httpRequest.getHeaders());
            }
            httpRequest.setParser((ObjectParser)new JsonObjectParser(this.jsonFactory));
            HttpResponse httpResponse = httpRequest.execute();
            ResponseT response = this.methodDescriptor.parseResponse(new InputStreamReader(httpResponse.getContent()));
            this.responseFuture.set(response);
        }
        catch (Exception e) {
            this.responseFuture.setException((Throwable)e);
        }
    }

    static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder() {
        return new Builder().setHeaderEnhancers(new LinkedList<HttpJsonHeaderEnhancer>());
    }

    static class Builder<RequestT, ResponseT> {
        private HttpJsonCallOptions callOptions;
        private RequestT request;
        private ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor;
        private HttpTransport httpTransport;
        private String endpoint;
        private JsonFactory jsonFactory;
        private List<HttpJsonHeaderEnhancer> headerEnhancers;
        private SettableApiFuture<ResponseT> responseFuture;

        private Builder() {
        }

        Builder<RequestT, ResponseT> setHttpJsonCallOptions(HttpJsonCallOptions callOptions) {
            this.callOptions = callOptions;
            return this;
        }

        Builder<RequestT, ResponseT> setRequest(RequestT request) {
            this.request = request;
            return this;
        }

        Builder<RequestT, ResponseT> setApiMethodDescriptor(ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor) {
            this.methodDescriptor = methodDescriptor;
            return this;
        }

        Builder<RequestT, ResponseT> setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        Builder<RequestT, ResponseT> setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        Builder<RequestT, ResponseT> setJsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
            return this;
        }

        Builder<RequestT, ResponseT> setHeaderEnhancers(List<HttpJsonHeaderEnhancer> headerEnhancers) {
            this.headerEnhancers = headerEnhancers;
            return this;
        }

        Builder<RequestT, ResponseT> setApiFuture(SettableApiFuture<ResponseT> responseFuture) {
            this.responseFuture = responseFuture;
            return this;
        }

        HttpRequestRunnable<RequestT, ResponseT> build() {
            return new HttpRequestRunnable(this.callOptions, this.request, this.methodDescriptor, this.httpTransport, this.endpoint, this.jsonFactory, this.headerEnhancers, this.responseFuture);
        }
    }
}

