/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcExceptionCallable;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.DataLossException;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.UnavailableException;
import com.google.api.gax.rpc.UnknownException;
import com.google.common.truth.Truth;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GrpcTransportDescriptorTest {
    private static boolean NOT_RETRYABLE = false;
    private static boolean IS_RETRYABLE = true;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void translateException_StatusException_noRetry() throws Exception {
        StatusException originalException = new StatusException(Status.INVALID_ARGUMENT);
        GrpcExceptionCallable exceptionCallable = new GrpcExceptionCallable(this.failingCallable((Throwable)originalException), Collections.emptySet());
        try {
            exceptionCallable.call((Object)0);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (Throwable throwable) {
            this.assertInnerExceptionIsInstanceOf(throwable, InvalidArgumentException.class, NOT_RETRYABLE, (Throwable)originalException);
        }
    }

    @Test
    public void translateException_StatusException_withRetry() throws Exception {
        StatusException originalException = new StatusException(Status.UNAVAILABLE);
        GrpcExceptionCallable exceptionCallable = new GrpcExceptionCallable(this.failingCallable((Throwable)originalException), Collections.singleton(StatusCode.Code.UNAVAILABLE));
        try {
            exceptionCallable.call((Object)0);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (Throwable throwable) {
            this.assertInnerExceptionIsInstanceOf(throwable, UnavailableException.class, IS_RETRYABLE, (Throwable)originalException);
        }
    }

    @Test
    public void translateException_StatusRuntimeException_noRetry() throws Exception {
        StatusRuntimeException originalException = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        GrpcExceptionCallable exceptionCallable = new GrpcExceptionCallable(this.failingCallable((Throwable)originalException), Collections.emptySet());
        try {
            exceptionCallable.call((Object)0);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (Throwable throwable) {
            this.assertInnerExceptionIsInstanceOf(throwable, InvalidArgumentException.class, NOT_RETRYABLE, (Throwable)originalException);
        }
    }

    @Test
    public void translateException_StatusRuntimeException_withRetry() throws Exception {
        StatusRuntimeException originalException = new StatusRuntimeException(Status.UNAVAILABLE);
        GrpcExceptionCallable exceptionCallable = new GrpcExceptionCallable(this.failingCallable((Throwable)originalException), Collections.singleton(StatusCode.Code.UNAVAILABLE));
        try {
            exceptionCallable.call((Object)0);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (Throwable throwable) {
            this.assertInnerExceptionIsInstanceOf(throwable, UnavailableException.class, IS_RETRYABLE, (Throwable)originalException);
        }
    }

    @Test
    public void translateException_cancelled() throws Exception {
        GrpcExceptionCallable exceptionCallable = new GrpcExceptionCallable(this.inactiveCallable(), Collections.emptySet());
        ApiFuture result = exceptionCallable.futureCall((Object)0);
        Truth.assertThat((Boolean)result.isDone()).isFalse();
        result.cancel(true);
        Truth.assertThat((Boolean)result.isCancelled()).isTrue();
        Truth.assertThat((Boolean)result.isDone()).isTrue();
    }

    @Test
    public void translateException_ApiException() throws Exception {
        RuntimeException originalException = new RuntimeException("stuff went wrong");
        DataLossException apiException = new DataLossException((Throwable)originalException, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.UNKNOWN), IS_RETRYABLE);
        GrpcExceptionCallable exceptionCallable = new GrpcExceptionCallable(this.failingCallable((Throwable)apiException), Collections.emptySet());
        try {
            exceptionCallable.call((Object)0);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (Throwable throwable) {
            this.assertInnerExceptionIsInstanceOf(throwable, DataLossException.class, IS_RETRYABLE, originalException);
        }
    }

    @Test
    public void translateException_RuntimeException() throws Exception {
        RuntimeException originalException = new RuntimeException("stuff went wrong");
        GrpcExceptionCallable exceptionCallable = new GrpcExceptionCallable(this.failingCallable(originalException), Collections.emptySet());
        try {
            exceptionCallable.call((Object)0);
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (Throwable throwable) {
            this.assertInnerExceptionIsInstanceOf(throwable, UnknownException.class, NOT_RETRYABLE, originalException);
        }
    }

    private UnaryCallable<Integer, Integer> failingCallable(final Throwable exception) {
        return new UnaryCallable<Integer, Integer>(){

            public ApiFuture<Integer> futureCall(Integer request, ApiCallContext context) {
                return ApiFutures.immediateFailedFuture((Throwable)exception);
            }
        };
    }

    private UnaryCallable<Integer, Integer> inactiveCallable() {
        return new UnaryCallable<Integer, Integer>(){

            public ApiFuture<Integer> futureCall(Integer request, ApiCallContext context) {
                return SettableApiFuture.create();
            }
        };
    }

    public void assertInnerExceptionIsInstanceOf(Throwable thrownException, Class<?> clazz, boolean retryable, Throwable originalException) throws Exception {
        Truth.assertThat((Throwable)thrownException).isInstanceOf(clazz);
        ApiException apiException = (ApiException)thrownException;
        Truth.assertThat((Boolean)apiException.isRetryable()).isEqualTo((Object)retryable);
    }
}

