/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.CallOptionsUtil;
import com.google.common.collect.ImmutableMap;
import io.grpc.CallOptions;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class CallOptionsUtilTest {
    @Test
    public void testPutAndGetDynamicHeaderOption() throws Exception {
        String encodedRequestParams = "param1=value&param2.param3=value23";
        CallOptions options = CallOptionsUtil.putRequestParamsDynamicHeaderOption((CallOptions)CallOptions.DEFAULT, (String)encodedRequestParams);
        Map headers = CallOptionsUtil.getDynamicHeadersOption((CallOptions)options);
        Assert.assertEquals((Object)ImmutableMap.of((Object)CallOptionsUtil.REQUEST_PARAMS_HEADER_KEY, (Object)encodedRequestParams), (Object)headers);
    }

    @Test
    public void testPutAndGetDynamicHeaderOptionEmpty() throws Exception {
        CallOptions options = CallOptionsUtil.putRequestParamsDynamicHeaderOption((CallOptions)CallOptions.DEFAULT, (String)"");
        Assert.assertSame((Object)CallOptions.DEFAULT, (Object)options);
        Map headers = CallOptionsUtil.getDynamicHeadersOption((CallOptions)options);
        Assert.assertTrue((boolean)headers.isEmpty());
    }

    @Test(expected=NullPointerException.class)
    public void testPutAndGetHeaderOptionNull() throws Exception {
        CallOptionsUtil.putRequestParamsDynamicHeaderOption((CallOptions)CallOptions.DEFAULT, null);
    }
}

