/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.grpc.GrpcMetadataHandlerInterceptor;
import com.google.api.gax.grpc.GrpcResponseMetadata;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.testing.FakeServiceGrpc;
import com.google.api.gax.grpc.testing.InProcessServer;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.type.Color;
import com.google.type.Money;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingServerCall;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.stub.StreamObserver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class GrpcResponseMetadataTest {
    private static final String HEADER_KEY = "inprocessheaderkey";
    private static final String HEADER_VALUE = "inprocessheadervalue";
    private static final String TRAILER_KEY = "inprocesstrailerkey";
    private static final String TRAILER_VALUE = "inprocesstrailervalue";
    private InProcessServer<FakeServiceGrpc.FakeServiceImplBase> inprocessServer;
    private ManagedChannel channel;
    private ClientContext clientContext;
    private Metadata requestHeaders = null;

    @Before
    public void setUp() throws Exception {
        String serverName = "fakeservice";
        FakeServiceGrpc.FakeServiceImplBase serviceImpl = (FakeServiceGrpc.FakeServiceImplBase)Mockito.mock(FakeServiceGrpc.FakeServiceImplBase.class);
        ((FakeServiceGrpc.FakeServiceImplBase)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Color color = (Color)invocation.getArgument(0);
                StreamObserver observer = (StreamObserver)invocation.getArgument(1);
                observer.onNext((Object)Money.newBuilder().setCurrencyCode("USD").setUnits((long)(color.getRed() * 255.0f)).build());
                observer.onCompleted();
                return null;
            }
        }).when((Object)serviceImpl)).recognize((Color)Mockito.any(), (StreamObserver<Money>)((StreamObserver)Mockito.any()));
        this.requestHeaders = null;
        this.inprocessServer = new InProcessServer<FakeServiceGrpc.FakeServiceImplBase>(serviceImpl, serverName, new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                GrpcResponseMetadataTest.this.requestHeaders = headers;
                return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                    public void sendHeaders(Metadata responseHeaders) {
                        responseHeaders.put(Metadata.Key.of((String)GrpcResponseMetadataTest.HEADER_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)GrpcResponseMetadataTest.HEADER_VALUE);
                        super.sendHeaders(responseHeaders);
                    }

                    public void close(Status status, Metadata trailers) {
                        trailers.put(Metadata.Key.of((String)GrpcResponseMetadataTest.TRAILER_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)GrpcResponseMetadataTest.TRAILER_VALUE);
                        super.close(status, trailers);
                    }
                }, headers);
            }
        });
        this.inprocessServer.start();
        this.channel = ((InProcessChannelBuilder)((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).usePlaintext().intercept(new ClientInterceptor[]{new GrpcMetadataHandlerInterceptor()})).build();
        this.clientContext = ClientContext.newBuilder().setTransportChannel((TransportChannel)GrpcTransportChannel.create((ManagedChannel)this.channel)).setDefaultCallContext((ApiCallContext)GrpcCallContext.of((Channel)this.channel, (CallOptions)CallOptions.DEFAULT)).build();
    }

    @After
    public void tearDown() {
        this.channel.shutdown();
        this.inprocessServer.stop();
    }

    @Test
    public void testResponseMetadataUnaryCall() throws Exception {
        GrpcCallSettings grpcCallSettings = GrpcCallSettings.create(FakeServiceGrpc.METHOD_RECOGNIZE);
        UnaryCallSettings callSettings = UnaryCallSettings.newUnaryCallSettingsBuilder().build();
        UnaryCallable callable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)grpcCallSettings, (UnaryCallSettings)callSettings, (ClientContext)this.clientContext);
        Assert.assertNull((Object)this.requestHeaders);
        GrpcResponseMetadata responseMetadata = new GrpcResponseMetadata();
        callable.call((Object)Color.getDefaultInstance(), (ApiCallContext)responseMetadata.createContextWithHandlers());
        Assert.assertNotNull((Object)this.requestHeaders);
        Metadata metadata = responseMetadata.getMetadata();
        Metadata trailingMetadata = responseMetadata.getTrailingMetadata();
        Assert.assertEquals((Object)metadata.get(Metadata.Key.of((String)HEADER_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)), (Object)HEADER_VALUE);
        Assert.assertEquals((Object)trailingMetadata.get(Metadata.Key.of((String)TRAILER_KEY, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)), (Object)TRAILER_VALUE);
    }
}

