/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.grpc.GrpcDirectServerStreamingCallableTest;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.testing.FakeServiceGrpc;
import com.google.api.gax.grpc.testing.FakeServiceImpl;
import com.google.api.gax.grpc.testing.InProcessServer;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.common.truth.Truth;
import com.google.type.Color;
import com.google.type.Money;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessChannelBuilder;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GrpcDirectStreamingCallableTest {
    private InProcessServer<FakeServiceImpl> inprocessServer;
    private ManagedChannel channel;
    private FakeServiceImpl serviceImpl;
    private ClientContext clientContext;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws InstantiationException, IllegalAccessException, IOException {
        String serverName = "fakeservice";
        this.serviceImpl = new FakeServiceImpl();
        this.inprocessServer = new InProcessServer<FakeServiceImpl>(this.serviceImpl, serverName);
        this.inprocessServer.start();
        this.channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).usePlaintext().build();
        this.clientContext = ClientContext.newBuilder().setTransportChannel((TransportChannel)GrpcTransportChannel.create((ManagedChannel)this.channel)).setDefaultCallContext((ApiCallContext)GrpcCallContext.of((Channel)this.channel, (CallOptions)CallOptions.DEFAULT)).build();
    }

    @After
    public void tearDown() {
        this.channel.shutdown();
        this.inprocessServer.stop();
    }

    @Test
    public void testBidiStreaming() throws Exception {
        BidiStreamingCallable streamingCallable = GrpcCallableFactory.createBidiStreamingCallable((GrpcCallSettings)GrpcCallSettings.create(FakeServiceGrpc.METHOD_STREAMING_RECOGNIZE), null, (ClientContext)this.clientContext);
        CountDownLatch latch = new CountDownLatch(1);
        GrpcDirectServerStreamingCallableTest.MoneyObserver moneyObserver = new GrpcDirectServerStreamingCallableTest.MoneyObserver(true, latch);
        Color request = Color.newBuilder().setRed(0.5f).build();
        ClientStream stream = streamingCallable.splitCall((ResponseObserver)moneyObserver);
        stream.send((Object)request);
        stream.closeSend();
        latch.await(20L, TimeUnit.SECONDS);
        Truth.assertThat((Throwable)moneyObserver.error).isNull();
        Money expected = Money.newBuilder().setCurrencyCode("USD").setUnits(127L).build();
        Truth.assertThat((Object)moneyObserver.response).isEqualTo((Object)expected);
        Truth.assertThat((Boolean)moneyObserver.completed).isTrue();
    }

    @Test
    public void testBidiStreamingServerError() throws Exception {
        BidiStreamingCallable streamingCallable = GrpcCallableFactory.createBidiStreamingCallable((GrpcCallSettings)GrpcCallSettings.create(FakeServiceGrpc.METHOD_STREAMING_RECOGNIZE_ERROR), null, (ClientContext)this.clientContext);
        CountDownLatch latch = new CountDownLatch(1);
        GrpcDirectServerStreamingCallableTest.MoneyObserver moneyObserver = new GrpcDirectServerStreamingCallableTest.MoneyObserver(true, latch);
        Color request = Color.newBuilder().setRed(0.5f).build();
        ClientStream stream = streamingCallable.splitCall((ResponseObserver)moneyObserver);
        stream.send((Object)request);
        latch.await(20L, TimeUnit.SECONDS);
        Truth.assertThat((Throwable)moneyObserver.error).isNotNull();
        Truth.assertThat((Throwable)moneyObserver.error).isInstanceOf(ApiException.class);
        Truth.assertThat((Throwable)moneyObserver.error.getCause()).isInstanceOf(StatusRuntimeException.class);
        Truth.assertThat((Object)((StatusRuntimeException)moneyObserver.error.getCause()).getStatus()).isEqualTo((Object)Status.INVALID_ARGUMENT);
        Truth.assertThat((Object)moneyObserver.response).isNull();
    }

    @Test
    public void testBidiStreamingClientError() throws Exception {
        BidiStreamingCallable streamingCallable = GrpcCallableFactory.createBidiStreamingCallable((GrpcCallSettings)GrpcCallSettings.create(FakeServiceGrpc.METHOD_STREAMING_RECOGNIZE_ERROR), null, (ClientContext)this.clientContext);
        CountDownLatch latch = new CountDownLatch(1);
        GrpcDirectServerStreamingCallableTest.MoneyObserver moneyObserver = new GrpcDirectServerStreamingCallableTest.MoneyObserver(true, latch);
        Color request = Color.newBuilder().setRed(0.5f).build();
        ClientStream stream = streamingCallable.splitCall((ResponseObserver)moneyObserver);
        StatusRuntimeException clientError = new StatusRuntimeException(Status.CANCELLED);
        stream.closeSendWithError((Throwable)clientError);
        latch.await(20L, TimeUnit.SECONDS);
        Truth.assertThat((Throwable)moneyObserver.error).isNotNull();
        Truth.assertThat((Throwable)moneyObserver.error).isInstanceOf(ApiException.class);
        Truth.assertThat((Comparable)((ApiException)moneyObserver.error).getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.CANCELLED);
        Truth.assertThat((Object)moneyObserver.response).isNull();
    }

    @Test
    public void testClientStreaming() throws Exception {
        ClientStreamingCallable streamingCallable = GrpcCallableFactory.createClientStreamingCallable((GrpcCallSettings)GrpcCallSettings.create(FakeServiceGrpc.METHOD_CLIENT_STREAMING_RECOGNIZE), null, (ClientContext)this.clientContext);
        CountDownLatch latch = new CountDownLatch(1);
        MoneyObserver moneyObserver = new MoneyObserver(latch);
        Color request = Color.newBuilder().setRed(0.5f).build();
        ApiStreamObserver requestObserver = streamingCallable.clientStreamingCall((ApiStreamObserver)moneyObserver);
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        latch.await(20L, TimeUnit.SECONDS);
        Truth.assertThat((Throwable)moneyObserver.error).isNull();
        Money expected = Money.newBuilder().setCurrencyCode("USD").setUnits(127L).build();
        Truth.assertThat((Object)moneyObserver.response).isEqualTo((Object)expected);
        Truth.assertThat((Boolean)moneyObserver.completed).isTrue();
    }

    private static class MoneyObserver
    implements ApiStreamObserver<Money> {
        volatile Money response;
        volatile Throwable error;
        volatile boolean completed;
        CountDownLatch latch;

        MoneyObserver(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onNext(Money value) {
            this.response = value;
            this.latch.countDown();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.latch.countDown();
        }

        public void onCompleted() {
            this.completed = true;
        }
    }
}

