/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.grpc.CallOptionsUtil;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.DeadlineExceededException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.Deadline;
import io.grpc.Status;
import io.grpc.auth.MoreCallCredentials;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@BetaApi(value="Reference ApiCallContext instead - this class is likely to experience breaking changes")
@InternalExtensionOnly
public final class GrpcCallContext
implements ApiCallContext {
    private final Channel channel;
    private final CallOptions callOptions;
    @Nullable
    private final Duration streamWaitTimeout;
    @Nullable
    private final Duration streamIdleTimeout;
    @Nullable
    private final Integer channelAffinity;

    public static GrpcCallContext createDefault() {
        return new GrpcCallContext(null, CallOptions.DEFAULT, null, null, null);
    }

    public static GrpcCallContext of(Channel channel, CallOptions callOptions) {
        return new GrpcCallContext(channel, callOptions, null, null, null);
    }

    private GrpcCallContext(Channel channel, CallOptions callOptions, @Nullable Duration streamWaitTimeout, @Nullable Duration streamIdleTimeout, @Nullable Integer channelAffinity) {
        this.channel = channel;
        this.callOptions = (CallOptions)Preconditions.checkNotNull((Object)callOptions);
        this.streamWaitTimeout = streamWaitTimeout;
        this.streamIdleTimeout = streamIdleTimeout;
        this.channelAffinity = channelAffinity;
    }

    public GrpcCallContext nullToSelf(ApiCallContext inputContext) {
        GrpcCallContext grpcCallContext;
        if (inputContext == null) {
            grpcCallContext = this;
        } else {
            if (!(inputContext instanceof GrpcCallContext)) {
                throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + inputContext.getClass().getName());
            }
            grpcCallContext = (GrpcCallContext)inputContext;
        }
        return grpcCallContext;
    }

    public GrpcCallContext withCredentials(Credentials newCredentials) {
        Preconditions.checkNotNull((Object)newCredentials);
        CallCredentials callCredentials = MoreCallCredentials.from((Credentials)newCredentials);
        return this.withCallOptions(this.callOptions.withCallCredentials(callCredentials));
    }

    public GrpcCallContext withTransportChannel(TransportChannel inputChannel) {
        Preconditions.checkNotNull((Object)inputChannel);
        if (!(inputChannel instanceof GrpcTransportChannel)) {
            throw new IllegalArgumentException("Expected GrpcTransportChannel, got " + inputChannel.getClass().getName());
        }
        GrpcTransportChannel transportChannel = (GrpcTransportChannel)inputChannel;
        return this.withChannel(transportChannel.getChannel());
    }

    public GrpcCallContext withTimeout(Duration rpcTimeout) {
        if (rpcTimeout == null) {
            return this.withCallOptions(this.callOptions.withDeadline(null));
        }
        if (rpcTimeout.isZero() || rpcTimeout.isNegative()) {
            throw new DeadlineExceededException("Invalid timeout: <= 0 s", null, (StatusCode)GrpcStatusCode.of(Status.Code.DEADLINE_EXCEEDED), false);
        }
        CallOptions oldOptions = this.callOptions;
        CallOptions newOptions = oldOptions.withDeadlineAfter(rpcTimeout.toMillis(), TimeUnit.MILLISECONDS);
        GrpcCallContext nextContext = this.withCallOptions(newOptions);
        if (oldOptions.getDeadline() == null) {
            return nextContext;
        }
        if (oldOptions.getDeadline().isBefore(newOptions.getDeadline())) {
            return this;
        }
        return nextContext;
    }

    public GrpcCallContext withStreamWaitTimeout(@Nullable Duration streamWaitTimeout) {
        if (streamWaitTimeout != null) {
            Preconditions.checkArgument((streamWaitTimeout.compareTo(Duration.ZERO) >= 0 ? 1 : 0) != 0, (Object)"Invalid timeout: < 0 s");
        }
        return new GrpcCallContext(this.channel, this.callOptions, streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity);
    }

    public GrpcCallContext withStreamIdleTimeout(@Nullable Duration streamIdleTimeout) {
        if (streamIdleTimeout != null) {
            Preconditions.checkArgument((streamIdleTimeout.compareTo(Duration.ZERO) >= 0 ? 1 : 0) != 0, (Object)"Invalid timeout: < 0 s");
        }
        return new GrpcCallContext(this.channel, this.callOptions, this.streamWaitTimeout, streamIdleTimeout, this.channelAffinity);
    }

    public GrpcCallContext withChannelAffinity(@Nullable Integer affinity) {
        return new GrpcCallContext(this.channel, this.callOptions, this.streamWaitTimeout, this.streamIdleTimeout, affinity);
    }

    public ApiCallContext merge(ApiCallContext inputCallContext) {
        Integer newChannelAffinity;
        Duration newStreamIdleTimeout;
        Duration newStreamWaitTimeout;
        CallCredentials newCallCredentials;
        Deadline newDeadline;
        if (inputCallContext == null) {
            return this;
        }
        if (!(inputCallContext instanceof GrpcCallContext)) {
            throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + inputCallContext.getClass().getName());
        }
        GrpcCallContext grpcCallContext = (GrpcCallContext)inputCallContext;
        Channel newChannel = grpcCallContext.channel;
        if (newChannel == null) {
            newChannel = this.channel;
        }
        if ((newDeadline = grpcCallContext.callOptions.getDeadline()) == null) {
            newDeadline = this.callOptions.getDeadline();
        }
        if ((newCallCredentials = grpcCallContext.callOptions.getCredentials()) == null) {
            newCallCredentials = this.callOptions.getCredentials();
        }
        if ((newStreamWaitTimeout = grpcCallContext.streamWaitTimeout) == null) {
            newStreamWaitTimeout = this.streamWaitTimeout;
        }
        if ((newStreamIdleTimeout = grpcCallContext.streamIdleTimeout) == null) {
            newStreamIdleTimeout = this.streamIdleTimeout;
        }
        if ((newChannelAffinity = grpcCallContext.channelAffinity) == null) {
            newChannelAffinity = this.channelAffinity;
        }
        CallOptions newCallOptions = grpcCallContext.callOptions.withCallCredentials(newCallCredentials).withDeadline(newDeadline);
        return new GrpcCallContext(newChannel, newCallOptions, newStreamWaitTimeout, newStreamIdleTimeout, newChannelAffinity);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public CallOptions getCallOptions() {
        return this.callOptions;
    }

    @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
    @Nullable
    public Duration getStreamWaitTimeout() {
        return this.streamWaitTimeout;
    }

    @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
    @Nullable
    public Duration getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
    @Nullable
    public Integer getChannelAffinity() {
        return this.channelAffinity;
    }

    public GrpcCallContext withChannel(Channel newChannel) {
        return new GrpcCallContext(newChannel, this.callOptions, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity);
    }

    public GrpcCallContext withCallOptions(CallOptions newCallOptions) {
        return new GrpcCallContext(this.channel, newCallOptions, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity);
    }

    public GrpcCallContext withRequestParamsDynamicHeaderOption(String requestParams) {
        CallOptions newCallOptions = CallOptionsUtil.putRequestParamsDynamicHeaderOption(this.callOptions, requestParams);
        return this.withCallOptions(newCallOptions);
    }

    @InternalApi(value="for testing")
    Deadline getDeadline() {
        return this.callOptions.getDeadline();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcCallContext that = (GrpcCallContext)o;
        return Objects.equals(this.channel, that.channel) && Objects.equals(this.callOptions, that.callOptions) && Objects.equals(this.streamWaitTimeout, that.streamWaitTimeout) && Objects.equals(this.streamIdleTimeout, that.streamIdleTimeout) && Objects.equals(this.channelAffinity, that.channelAffinity);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.callOptions, this.streamWaitTimeout, this.streamIdleTimeout, this.channelAffinity);
    }
}

