/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.common.collect.ImmutableMap;
import io.grpc.CallOptions;
import io.grpc.Metadata;
import java.util.Collections;
import java.util.Map;

class CallOptionsUtil {
    private static final CallOptions.Key<Map<Metadata.Key<String>, String>> DYNAMIC_HEADERS_CALL_OPTION_KEY = CallOptions.Key.of((String)"gax_dynamic_headers", Collections.emptyMap());
    static Metadata.Key<String> REQUEST_PARAMS_HEADER_KEY = Metadata.Key.of((String)"x-goog-request-params", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    private CallOptionsUtil() {
    }

    static CallOptions putRequestParamsDynamicHeaderOption(CallOptions callOptions, String requestParams) {
        if (callOptions == null || requestParams.isEmpty()) {
            return callOptions;
        }
        Map dynamicHeadersOption = (Map)callOptions.getOption(DYNAMIC_HEADERS_CALL_OPTION_KEY);
        dynamicHeadersOption = ImmutableMap.builder().putAll(dynamicHeadersOption).put(REQUEST_PARAMS_HEADER_KEY, (Object)requestParams).build();
        return callOptions.withOption(DYNAMIC_HEADERS_CALL_OPTION_KEY, (Object)dynamicHeadersOption);
    }

    static Map<Metadata.Key<String>, String> getDynamicHeadersOption(CallOptions callOptions) {
        return (Map)callOptions.getOption(DYNAMIC_HEADERS_CALL_OPTION_KEY);
    }
}

