/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.client.util.Preconditions;
import com.google.api.gax.grpc.CallOptionsUtil;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.RequestParamsEncoder;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;

class GrpcClientCalls {
    private GrpcClientCalls() {
    }

    public static <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> descriptor, ApiCallContext context, RequestT request, RequestParamsEncoder<RequestT> paramsEncoder) {
        if (!(context instanceof GrpcCallContext)) {
            throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + context.getClass().getName());
        }
        GrpcCallContext grpcContext = (GrpcCallContext)context;
        Preconditions.checkNotNull((Object)grpcContext.getChannel());
        CallOptions callOptions = grpcContext.getCallOptions();
        Preconditions.checkNotNull((Object)callOptions);
        if (paramsEncoder != null) {
            callOptions = CallOptionsUtil.putRequestParamsDynamicHeaderOption(callOptions, paramsEncoder.encode(request));
        }
        return grpcContext.getChannel().newCall(descriptor, callOptions);
    }
}

