/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.base.Preconditions;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.Operation;
import java.util.concurrent.ExecutionException;

class OperationCheckingCallable<RequestT>
extends UnaryCallable<RequestT, Operation> {
    private final UnaryCallable<GetOperationRequest, Operation> callable;
    private final ApiFuture<Operation> initialFuture;

    OperationCheckingCallable(UnaryCallable<GetOperationRequest, Operation> callable, ApiFuture<Operation> initialFuture) {
        this.callable = (UnaryCallable)Preconditions.checkNotNull(callable);
        this.initialFuture = (ApiFuture)Preconditions.checkNotNull(initialFuture);
    }

    public ApiFuture<Operation> futureCall(RequestT request, ApiCallContext context) {
        try {
            if (!this.initialFuture.isDone() || this.initialFuture.isCancelled()) {
                return this.initialFuture;
            }
            Operation initialOperation = (Operation)this.initialFuture.get();
            if (initialOperation.getDone()) {
                return this.initialFuture;
            }
            GetOperationRequest pollingRequest = GetOperationRequest.newBuilder().setName(initialOperation.getName()).build();
            return this.callable.futureCall((Object)pollingRequest);
        }
        catch (ExecutionException e) {
            return ApiFutures.immediateFailedFuture((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            return ApiFutures.immediateFailedFuture((Throwable)e);
        }
    }
}

