/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.GrpcAttemptCallable;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.base.Preconditions;

class GrpcRetryingCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final RetryingExecutor<ResponseT> executor;

    GrpcRetryingCallable(UnaryCallable<RequestT, ResponseT> callable, RetryingExecutor<ResponseT> executor) {
        this.callable = (UnaryCallable)Preconditions.checkNotNull(callable);
        this.executor = (RetryingExecutor)Preconditions.checkNotNull(executor);
    }

    public RetryingFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        GrpcCallContext context = GrpcCallContext.getAsGrpcCallContextWithDefault(inputContext);
        GrpcAttemptCallable<RequestT, ResponseT> retryCallable = new GrpcAttemptCallable<RequestT, ResponseT>(this.callable, request, context);
        RetryingFuture retryingFuture = this.executor.createFuture(retryCallable);
        retryCallable.setExternalFuture(retryingFuture);
        retryCallable.call();
        return retryingFuture;
    }

    public String toString() {
        return String.format("retrying(%s)", this.callable);
    }
}

