/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.FutureCallable;
import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import io.grpc.CallCredentials;
import io.grpc.auth.MoreCallCredentials;

class AuthCallable<RequestT, ResponseT>
implements FutureCallable<RequestT, ResponseT> {
    private final FutureCallable<RequestT, ResponseT> callable;
    private final CallCredentials credentials;

    AuthCallable(FutureCallable<RequestT, ResponseT> callable, Credentials credentials) {
        this.callable = (FutureCallable)Preconditions.checkNotNull(callable);
        this.credentials = MoreCallCredentials.from((Credentials)((Credentials)Preconditions.checkNotNull((Object)credentials)));
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, CallContext context) {
        if (context.getCallOptions().getCredentials() == null) {
            context = context.withCallOptions(context.getCallOptions().withCallCredentials(this.credentials));
        }
        return this.callable.futureCall(request, context);
    }
}

