/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.ApiStreamObserver;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.DirectStreamingCallable;
import com.google.api.gax.grpc.StreamingCallSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Channel;
import java.util.Iterator;
import javax.annotation.Nullable;

@BetaApi
public class StreamingCallable<RequestT, ResponseT> {
    private final DirectStreamingCallable<RequestT, ResponseT> callable;
    private final Channel channel;
    @Nullable
    private final StreamingCallSettings settings;

    StreamingCallable(DirectStreamingCallable<RequestT, ResponseT> callable, Channel channel, StreamingCallSettings settings) {
        this.callable = callable;
        this.channel = channel;
        this.settings = settings;
    }

    public StreamingCallable<RequestT, ResponseT> bind(Channel boundChannel) {
        return new StreamingCallable<RequestT, ResponseT>(this.callable, boundChannel, this.settings);
    }

    public static <RequestT, ResponseT> StreamingCallable<RequestT, ResponseT> create(StreamingCallSettings<RequestT, ResponseT> streamingCallSettings, Channel channel) {
        return streamingCallSettings.createStreamingCallable(channel);
    }

    public ApiStreamObserver<RequestT> bidiStreamingCall(ApiStreamObserver<ResponseT> responseObserver) {
        Preconditions.checkNotNull((Object)this.channel);
        return this.callable.bidiStreamingCall(responseObserver, CallContext.createDefault().withChannel(this.channel));
    }

    public ApiStreamObserver<RequestT> bidiStreamingCall(ApiStreamObserver<ResponseT> responseObserver, CallContext context) {
        if (context.getChannel() == null) {
            context = context.withChannel(this.channel);
        }
        Preconditions.checkNotNull((Object)context.getChannel());
        return this.callable.bidiStreamingCall(responseObserver, context);
    }

    public void serverStreamingCall(RequestT request, ApiStreamObserver<ResponseT> responseObserver) {
        Preconditions.checkNotNull((Object)this.channel);
        this.callable.serverStreamingCall(request, responseObserver, CallContext.createDefault().withChannel(this.channel));
    }

    public void serverStreamingCall(RequestT request, ApiStreamObserver<ResponseT> responseObserver, CallContext context) {
        if (context.getChannel() == null) {
            context = context.withChannel(this.channel);
        }
        Preconditions.checkNotNull((Object)context.getChannel());
        this.callable.serverStreamingCall(request, responseObserver, context);
    }

    public Iterator<ResponseT> serverStreamingCall(RequestT request) {
        Preconditions.checkNotNull((Object)this.channel);
        return this.callable.blockingServerStreamingCall(request, CallContext.createDefault().withChannel(this.channel));
    }

    public Iterator<ResponseT> serverStreamingCall(RequestT request, CallContext context) {
        if (context.getChannel() == null) {
            context = context.withChannel(this.channel);
        }
        return this.callable.blockingServerStreamingCall(request, context);
    }

    public ApiStreamObserver<RequestT> clientStreamingCall(ApiStreamObserver<ResponseT> responseObserver) {
        Preconditions.checkNotNull((Object)this.channel);
        return this.callable.clientStreamingCall(responseObserver, CallContext.createDefault().withChannel(this.channel));
    }

    public ApiStreamObserver<RequestT> clientStreamingCall(ApiStreamObserver<ResponseT> responseObserver, CallContext context) {
        if (context.getChannel() == null) {
            context = context.withChannel(this.channel);
        }
        return this.callable.clientStreamingCall(responseObserver, context);
    }

    @VisibleForTesting
    Channel getChannel() {
        return this.channel;
    }
}

