/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.retrying.RetrySettings;
import io.grpc.Status;
import java.io.IOException;
import java.util.Set;

@BetaApi
public abstract class ClientSettings {
    private final ExecutorProvider executorProvider;
    private final ChannelProvider channelProvider;

    protected ClientSettings(ExecutorProvider executorProvider, ChannelProvider channelProvider) {
        this.executorProvider = executorProvider;
        this.channelProvider = channelProvider;
    }

    public final ChannelAndExecutor getChannelAndExecutor() throws IOException {
        return ChannelAndExecutor.create(this.executorProvider, this.channelProvider);
    }

    public final ExecutorProvider getExecutorProvider() {
        return this.executorProvider;
    }

    public final ChannelProvider getChannelProvider() {
        return this.channelProvider;
    }

    public static abstract class Builder {
        private ExecutorProvider executorProvider;
        private ChannelProvider channelProvider;

        protected Builder(ClientSettings settings) {
            this.executorProvider = settings.executorProvider;
            this.channelProvider = settings.channelProvider;
        }

        protected Builder(InstantiatingChannelProvider channelProvider) {
            this.executorProvider = InstantiatingExecutorProvider.newBuilder().build();
            this.channelProvider = channelProvider;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            this.channelProvider = channelProvider;
            return this;
        }

        public ExecutorProvider getExecutorProvider() {
            return this.executorProvider;
        }

        public ChannelProvider getChannelProvider() {
            return this.channelProvider;
        }

        protected Builder applyToAllUnaryMethods(Iterable<UnaryCallSettings.Builder> methodSettingsBuilders, UnaryCallSettings.Builder newSettingsBuilder) throws Exception {
            Set<Status.Code> newRetryableCodes = newSettingsBuilder.getRetryableCodes();
            RetrySettings.Builder newRetrySettingsBuilder = newSettingsBuilder.getRetrySettingsBuilder();
            for (UnaryCallSettings.Builder settingsBuilder : methodSettingsBuilders) {
                if (newRetryableCodes != null) {
                    settingsBuilder.setRetryableCodes(newRetryableCodes);
                }
                if (newRetrySettingsBuilder == null) continue;
                settingsBuilder.getRetrySettingsBuilder().merge(newRetrySettingsBuilder);
            }
            return this;
        }

        public abstract ClientSettings build() throws IOException;
    }
}

