/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.batching.RequestBuilder;
import com.google.api.gax.grpc.BatchedFuture;
import com.google.api.gax.grpc.BatchedRequestIssuer;
import com.google.api.gax.grpc.BatchingDescriptor;
import com.google.api.gax.grpc.UnaryCallable;
import java.util.ArrayList;
import java.util.List;

@BetaApi
public class Batch<RequestT, ResponseT> {
    private final List<BatchedRequestIssuer<ResponseT>> requestIssuerList;
    private final RequestBuilder<RequestT> requestBuilder;
    private UnaryCallable<RequestT, ResponseT> callable;
    private long byteCount;

    public Batch(BatchingDescriptor<RequestT, ResponseT> descriptor, RequestT request, UnaryCallable<RequestT, ResponseT> callable, BatchedFuture<ResponseT> batchedFuture) {
        this.requestBuilder = descriptor.getRequestBuilder();
        this.requestIssuerList = new ArrayList<BatchedRequestIssuer<ResponseT>>();
        this.requestBuilder.appendRequest(request);
        this.callable = callable;
        this.requestIssuerList.add(new BatchedRequestIssuer<ResponseT>(batchedFuture, descriptor.countElements(request)));
        this.byteCount = descriptor.countBytes(request);
    }

    public RequestT getRequest() {
        return (RequestT)this.requestBuilder.build();
    }

    public UnaryCallable<RequestT, ResponseT> getCallable() {
        return this.callable;
    }

    public List<BatchedRequestIssuer<ResponseT>> getRequestIssuerList() {
        return this.requestIssuerList;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void merge(Batch<RequestT, ResponseT> batch) {
        this.requestBuilder.appendRequest(batch.getRequest());
        this.requestIssuerList.addAll(batch.requestIssuerList);
        if (this.callable == null) {
            this.callable = batch.callable;
        }
        this.byteCount += batch.byteCount;
    }
}

