/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.utils;

import com.google.api.generator.engine.lexicon.Keyword;
import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import java.util.stream.IntStream;

public class JavaStyle {
    private static final String UNDERSCORE = "_";

    public static String toLowerCamelCase(String s) {
        if (Strings.isNullOrEmpty(s)) {
            return s;
        }
        if ((s = s.replace('-', '_')).indexOf(UNDERSCORE) >= 0) {
            s = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, s);
        }
        String name = JavaStyle.capitalizeLettersAfterDigits(String.format("%s%s", s.substring(0, 1).toLowerCase(), s.substring(1)));
        return Keyword.escapeKeyword(name);
    }

    public static String toUpperCamelCase(String s) {
        if (Strings.isNullOrEmpty(s)) {
            return s;
        }
        if ((s = s.replace('-', '_')).indexOf(UNDERSCORE) >= 0) {
            s = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, s);
        }
        return JavaStyle.capitalizeLettersAfterDigits(String.format("%s%s", s.substring(0, 1).toUpperCase(), s.substring(1)));
    }

    public static String toUpperSnakeCase(String s) {
        String result = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, JavaStyle.toUpperCamelCase(s));
        return result;
    }

    private static String capitalizeLettersAfterDigits(String s) {
        return IntStream.range(0, s.length()).collect(StringBuilder::new, (sb, i) -> sb.append(i > 0 && Character.isDigit(s.charAt(i - 1)) ? Character.toUpperCase(s.charAt(i)) : s.charAt(i)), StringBuilder::append).toString();
    }
}

