/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNode;
import com.google.api.generator.engine.ast.AstNodeVisitor;

public class ScopeNode
implements AstNode {
    private final ScopeKind scopeKind;
    public static final ScopeNode PRIVATE = new ScopeNode(ScopeKind.PRIVATE);
    public static final ScopeNode PROTECTED = new ScopeNode(ScopeKind.PROTECTED);
    public static final ScopeNode PUBLIC = new ScopeNode(ScopeKind.PUBLIC);
    public static final ScopeNode LOCAL = new ScopeNode(ScopeKind.LOCAL);

    private ScopeNode(ScopeKind scopeKind) {
        this.scopeKind = scopeKind;
    }

    public String toString() {
        switch (this.scopeKind) {
            case PRIVATE: {
                return "private";
            }
            case PROTECTED: {
                return "protected";
            }
            case PUBLIC: {
                return "public";
            }
        }
        return "";
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ScopeNode)) {
            return false;
        }
        ScopeNode scope = (ScopeNode)o;
        return this.scopeKind.equals((Object)scope.scopeKind);
    }

    public int hashCode() {
        return 17 * this.scopeKind.hashCode();
    }

    private static enum ScopeKind {
        LOCAL,
        PRIVATE,
        PROTECTED,
        PUBLIC;

    }
}

