/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_MethodInvocationExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.IdentifierNode;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
public abstract class MethodInvocationExpr
implements Expr {
    public abstract IdentifierNode methodIdentifier();

    public abstract TypeNode returnType();

    @Nullable
    public abstract Expr exprReferenceExpr();

    @Nullable
    public abstract TypeNode staticReferenceType();

    public abstract List<Expr> arguments();

    public abstract List<Reference> generics();

    abstract String methodName();

    public boolean isGeneric() {
        return !this.generics().isEmpty();
    }

    @Override
    public TypeNode type() {
        return this.returnType();
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_MethodInvocationExpr.Builder().setReturnType(TypeNode.VOID).setGenerics(Collections.emptyList()).setArguments(Collections.emptyList());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setMethodName(String var1);

        abstract String methodName();

        public abstract Builder setReturnType(TypeNode var1);

        public abstract Builder setExprReferenceExpr(Expr var1);

        public abstract Builder setStaticReferenceType(TypeNode var1);

        public Builder setArguments(Expr ... arguments) {
            return this.setArguments(Arrays.asList(arguments));
        }

        public abstract Builder setArguments(List<Expr> var1);

        public abstract Builder setGenerics(List<Reference> var1);

        abstract Builder setMethodIdentifier(IdentifierNode var1);

        abstract MethodInvocationExpr autoBuild();

        public MethodInvocationExpr build() {
            IdentifierNode identifier = IdentifierNode.builder().setName(this.methodName()).build();
            this.setMethodIdentifier(identifier);
            MethodInvocationExpr methodInvocationExpr = this.autoBuild();
            if (methodInvocationExpr.staticReferenceType() != null) {
                Preconditions.checkState(TypeNode.isReferenceType(methodInvocationExpr.staticReferenceType()), "Static references can only be made on object types");
            }
            Preconditions.checkState(!methodInvocationExpr.type().equals(TypeNode.NULL), "Methods cannot be invoked on null types.");
            Preconditions.checkState(methodInvocationExpr.exprReferenceExpr() == null || methodInvocationExpr.staticReferenceType() == null, "Only the expression reference or the static reference can be set, not both");
            NodeValidator.checkNoNullElements(methodInvocationExpr.arguments(), "arguments", String.format("method invocation of %s", methodInvocationExpr.methodIdentifier().name()));
            NodeValidator.checkNoNullElements(methodInvocationExpr.generics(), "generics", String.format("method invocation of %s", methodInvocationExpr.methodIdentifier().name()));
            return methodInvocationExpr;
        }
    }
}

