/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_ForStatement;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

@AutoValue
public abstract class ForStatement
implements Statement {
    public abstract VariableExpr localVariableExpr();

    public abstract Expr collectionExpr();

    public abstract ImmutableList<Statement> body();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_ForStatement.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setLocalVariableExpr(VariableExpr var1);

        public abstract Builder setBody(List<Statement> var1);

        public abstract Builder setCollectionExpr(Expr var1);

        abstract ForStatement autoBuild();

        public ForStatement build() {
            ForStatement forStatement = this.autoBuild();
            NodeValidator.checkNoNullElements(forStatement.body(), "body", "for-statement");
            Preconditions.checkState(forStatement.localVariableExpr().isDecl(), "For-statement variable must be a declaration");
            return forStatement;
        }
    }
}

