/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_ArrayExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.StringObjectValue;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;

@AutoValue
public abstract class ArrayExpr
implements Expr {
    public abstract List<Expr> exprs();

    @Override
    public abstract TypeNode type();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_ArrayExpr.Builder().setExprs(ImmutableList.of());
    }

    public static ArrayExpr withStrings(String ... stringValues) {
        Builder builder = ArrayExpr.builder();
        Arrays.asList(stringValues).stream().forEach(s -> builder.addExpr((String)s));
        return builder.build();
    }

    public static ArrayExpr withExprs(Expr ... exprs) {
        return ArrayExpr.builder().setExprs(Arrays.asList(exprs)).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        private static final String SAME_TYPE_EXPRS_MESSAGE = "All expressions must be of the type specified in this ArrayExpr";
        private static final String EXPR_ALLOWED_CLASSES_MESSAGE = "Only VariableExpr and ValueExpr can be used as elements of ArrayExpr";

        abstract List<Expr> exprs();

        abstract TypeNode type();

        public Builder addExpr(String expr) {
            return this.addExpr(ValueExpr.withValue(StringObjectValue.withValue(expr)));
        }

        public Builder addExpr(Expr expr) {
            return this.setExprs((List<Expr>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.exprs())).add(expr)).build()));
        }

        public abstract Builder setExprs(List<Expr> var1);

        public abstract Builder setType(TypeNode var1);

        abstract ArrayExpr autoBuild();

        public ArrayExpr build() {
            Preconditions.checkState(this.exprs().stream().allMatch(exp -> exp instanceof ValueExpr || exp instanceof VariableExpr), EXPR_ALLOWED_CLASSES_MESSAGE);
            TypeNode elementType = TypeNode.createElementTypeFromArrayType(this.type());
            Preconditions.checkState(this.exprs().stream().allMatch(exp -> exp.type().equals(elementType)), SAME_TYPE_EXPRS_MESSAGE);
            return this.autoBuild();
        }
    }
}

