/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.grpc.CallCredentials;
import io.grpc.MetricRecorder;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.GrpcBootstrapperImpl;
import io.grpc.xds.GrpcXdsTransportFactory;
import io.grpc.xds.MessagePrinter;
import io.grpc.xds.XdsClientMetricReporterImpl;
import io.grpc.xds.XdsClientPoolFactory;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsClientImpl;
import io.grpc.xds.client.XdsInitializationException;
import io.grpc.xds.internal.security.TlsContextManagerImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SharedXdsClientPoolProvider
implements XdsClientPoolFactory {
    private static final boolean LOG_XDS_NODE_ID = Boolean.parseBoolean(System.getenv("GRPC_LOG_XDS_NODE_ID"));
    private static final Logger log = Logger.getLogger(XdsClientImpl.class.getName());
    private static final ExponentialBackoffPolicy.Provider BACKOFF_POLICY_PROVIDER = new ExponentialBackoffPolicy.Provider();
    private final Bootstrapper bootstrapper;
    private final Object lock = new Object();
    private final AtomicReference<Map<String, ?>> bootstrapOverride = new AtomicReference();
    private final Map<String, ObjectPool<XdsClient>> targetToXdsClientMap = new ConcurrentHashMap<String, ObjectPool<XdsClient>>();

    SharedXdsClientPoolProvider() {
        this(new GrpcBootstrapperImpl());
    }

    @VisibleForTesting
    SharedXdsClientPoolProvider(Bootstrapper bootstrapper) {
        this.bootstrapper = Preconditions.checkNotNull(bootstrapper, "bootstrapper");
    }

    static SharedXdsClientPoolProvider getDefaultProvider() {
        return SharedXdsClientPoolProviderHolder.instance;
    }

    @Override
    public void setBootstrapOverride(Map<String, ?> bootstrap) {
        this.bootstrapOverride.set(bootstrap);
    }

    @Override
    @Nullable
    public ObjectPool<XdsClient> get(String target) {
        return this.targetToXdsClientMap.get(target);
    }

    @Override
    public ObjectPool<XdsClient> getOrCreate(String target, MetricRecorder metricRecorder) throws XdsInitializationException {
        return this.getOrCreate(target, metricRecorder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectPool<XdsClient> getOrCreate(String target, MetricRecorder metricRecorder, CallCredentials transportCallCredentials) throws XdsInitializationException {
        RefCountedXdsClientObjectPool ref = this.targetToXdsClientMap.get(target);
        if (ref == null) {
            Object object = this.lock;
            synchronized (object) {
                ref = this.targetToXdsClientMap.get(target);
                if (ref == null) {
                    Map<String, ?> rawBootstrap = this.bootstrapOverride.get();
                    Bootstrapper.BootstrapInfo bootstrapInfo = rawBootstrap != null ? this.bootstrapper.bootstrap(rawBootstrap) : this.bootstrapper.bootstrap();
                    if (bootstrapInfo.servers().isEmpty()) {
                        throw new XdsInitializationException("No xDS server provided");
                    }
                    ref = new RefCountedXdsClientObjectPool(bootstrapInfo, target, metricRecorder, transportCallCredentials);
                    this.targetToXdsClientMap.put(target, ref);
                }
            }
        }
        return ref;
    }

    public ImmutableList<String> getTargets() {
        return ImmutableList.copyOf(this.targetToXdsClientMap.keySet());
    }

    @ThreadSafe
    @VisibleForTesting
    class RefCountedXdsClientObjectPool
    implements ObjectPool<XdsClient> {
        private final Bootstrapper.BootstrapInfo bootstrapInfo;
        private final String target;
        private final MetricRecorder metricRecorder;
        private final CallCredentials transportCallCredentials;
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private ScheduledExecutorService scheduler;
        @GuardedBy(value="lock")
        private XdsClient xdsClient;
        @GuardedBy(value="lock")
        private int refCount;
        @GuardedBy(value="lock")
        private XdsClientMetricReporterImpl metricReporter;

        @VisibleForTesting
        RefCountedXdsClientObjectPool(Bootstrapper.BootstrapInfo bootstrapInfo, String target, MetricRecorder metricRecorder) {
            this(bootstrapInfo, target, metricRecorder, null);
        }

        @VisibleForTesting
        RefCountedXdsClientObjectPool(Bootstrapper.BootstrapInfo bootstrapInfo, String target, MetricRecorder metricRecorder, CallCredentials transportCallCredentials) {
            this.bootstrapInfo = Preconditions.checkNotNull(bootstrapInfo);
            this.target = target;
            this.metricRecorder = metricRecorder;
            this.transportCallCredentials = transportCallCredentials;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XdsClient getObject() {
            Object object = this.lock;
            synchronized (object) {
                if (this.refCount == 0) {
                    if (LOG_XDS_NODE_ID) {
                        log.log(Level.INFO, "xDS node ID: {0}", this.bootstrapInfo.node().getId());
                    }
                    this.scheduler = SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE);
                    this.metricReporter = new XdsClientMetricReporterImpl(this.metricRecorder, this.target);
                    GrpcXdsTransportFactory xdsTransportFactory = new GrpcXdsTransportFactory(this.transportCallCredentials);
                    this.xdsClient = new XdsClientImpl(xdsTransportFactory, this.bootstrapInfo, this.scheduler, BACKOFF_POLICY_PROVIDER, GrpcUtil.STOPWATCH_SUPPLIER, TimeProvider.SYSTEM_TIME_PROVIDER, MessagePrinter.INSTANCE, new TlsContextManagerImpl(this.bootstrapInfo), this.metricReporter);
                    this.metricReporter.setXdsClient(this.xdsClient);
                }
                ++this.refCount;
                return this.xdsClient;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XdsClient returnObject(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                --this.refCount;
                if (this.refCount == 0) {
                    this.xdsClient.shutdown();
                    this.xdsClient = null;
                    this.metricReporter.close();
                    this.metricReporter = null;
                    SharedXdsClientPoolProvider.this.targetToXdsClientMap.remove(this.target);
                    this.scheduler = SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.scheduler);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @VisibleForTesting
        XdsClient getXdsClientForTest() {
            Object object = this.lock;
            synchronized (object) {
                return this.xdsClient;
            }
        }

        public String getTarget() {
            return this.target;
        }
    }

    private static class SharedXdsClientPoolProviderHolder {
        private static final SharedXdsClientPoolProvider instance = new SharedXdsClientPoolProvider();

        private SharedXdsClientPoolProviderHolder() {
        }
    }
}

