/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.collect.ImmutableList;
import io.grpc.CallCredentials;
import io.grpc.ChannelCredentials;
import io.grpc.CompositeChannelCredentials;
import io.grpc.Status;
import io.grpc.alts.DualCallCredentials;
import io.grpc.alts.FailingCallCredentials;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelCredentials;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.IOException;
import javax.net.ssl.SSLException;

public final class GoogleDefaultChannelCredentials {
    private GoogleDefaultChannelCredentials() {
    }

    public static ChannelCredentials create() {
        return GoogleDefaultChannelCredentials.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private CallCredentials callCredentials;
        private CallCredentials altsCallCredentials;

        private Builder() {
        }

        public Builder callCredentials(CallCredentials callCreds) {
            this.callCredentials = callCreds;
            return this;
        }

        public Builder altsCallCredentials(CallCredentials callCreds) {
            this.altsCallCredentials = callCreds;
            return this;
        }

        public ChannelCredentials build() {
            ChannelCredentials nettyCredentials = InternalNettyChannelCredentials.create(Builder.createClientFactory());
            CallCredentials tlsCallCreds = this.callCredentials;
            if (tlsCallCreds == null) {
                try {
                    tlsCallCreds = MoreCallCredentials.from(GoogleCredentials.getApplicationDefault());
                }
                catch (IOException e) {
                    tlsCallCreds = new FailingCallCredentials(Status.UNAUTHENTICATED.withDescription("Failed to get Google default credentials").withCause(e));
                }
            }
            CallCredentials callCreds = this.altsCallCredentials == null ? tlsCallCreds : new DualCallCredentials(tlsCallCreds, this.altsCallCredentials);
            return CompositeChannelCredentials.create(nettyCredentials, callCreds);
        }

        private static InternalProtocolNegotiator.ClientFactory createClientFactory() {
            SslContext sslContext;
            try {
                sslContext = GrpcSslContexts.forClient().build();
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
            return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext);
        }
    }
}

