/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protoparser;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.protobuf.compiler.PluginProtos;
import java.util.Arrays;
import java.util.Optional;

public class PluginArgumentParser {
    private static final String COMMA = ",";
    private static final String EQUALS = "=";
    @VisibleForTesting
    static final String KEY_GRPC_SERVICE_CONFIG = "grpc-service-config";
    @VisibleForTesting
    static final String KEY_GAPIC_CONFIG = "gapic-config";
    @VisibleForTesting
    static final String KEY_METADATA = "metadata";
    @VisibleForTesting
    static final String KEY_NUMERIC_ENUM = "rest-numeric-enums";
    @VisibleForTesting
    static final String KEY_SERVICE_YAML_CONFIG = "api-service-config";
    @VisibleForTesting
    static final String KEY_TRANSPORT = "transport";
    private static final String JSON_FILE_ENDING = "grpc_service_config.json";
    private static final String GAPIC_YAML_FILE_ENDING = "gapic.yaml";
    private static final String SERVICE_YAML_FILE_ENDING = ".yaml";

    static Optional<String> parseJsonConfigPath(PluginProtos.CodeGeneratorRequest request) {
        return PluginArgumentParser.parseJsonConfigPath(request.getParameter());
    }

    static Optional<String> parseGapicYamlConfigPath(PluginProtos.CodeGeneratorRequest request) {
        return PluginArgumentParser.parseGapicYamlConfigPath(request.getParameter());
    }

    static Optional<String> parseServiceYamlConfigPath(PluginProtos.CodeGeneratorRequest request) {
        return PluginArgumentParser.parseServiceYamlConfigPath(request.getParameter());
    }

    static Optional<String> parseTransport(PluginProtos.CodeGeneratorRequest request) {
        return PluginArgumentParser.parseConfigArgument(request.getParameter(), KEY_TRANSPORT);
    }

    static boolean hasMetadataFlag(PluginProtos.CodeGeneratorRequest request) {
        return PluginArgumentParser.hasFlag(request.getParameter(), KEY_METADATA);
    }

    static boolean hasNumericEnumFlag(PluginProtos.CodeGeneratorRequest request) {
        return PluginArgumentParser.hasFlag(request.getParameter(), KEY_NUMERIC_ENUM);
    }

    @VisibleForTesting
    static Optional<String> parseJsonConfigPath(String pluginProtocArgument) {
        return PluginArgumentParser.parseFileArgument(pluginProtocArgument, KEY_GRPC_SERVICE_CONFIG, JSON_FILE_ENDING);
    }

    @VisibleForTesting
    static Optional<String> parseGapicYamlConfigPath(String pluginProtocArgument) {
        return PluginArgumentParser.parseFileArgument(pluginProtocArgument, KEY_GAPIC_CONFIG, GAPIC_YAML_FILE_ENDING);
    }

    @VisibleForTesting
    static Optional<String> parseServiceYamlConfigPath(String pluginProtocArgument) {
        return PluginArgumentParser.parseFileArgument(pluginProtocArgument, KEY_SERVICE_YAML_CONFIG, SERVICE_YAML_FILE_ENDING);
    }

    @VisibleForTesting
    private static Optional<String> parseConfigArgument(String pluginProtocArgument, String key) {
        if (Strings.isNullOrEmpty(pluginProtocArgument)) {
            return Optional.empty();
        }
        for (String argComponent : pluginProtocArgument.split(COMMA)) {
            String[] args = argComponent.trim().split(EQUALS);
            if (args.length != 2 || !key.equals(args[0])) continue;
            return Optional.of(args[1]);
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static boolean hasFlag(String pluginProtocArgument, String flagKey) {
        return Arrays.stream(pluginProtocArgument.split(COMMA)).anyMatch(s -> s.equals(flagKey));
    }

    private static Optional<String> parseFileArgument(String pluginProtocArgument, String key, String fileEnding) {
        if (Strings.isNullOrEmpty(pluginProtocArgument)) {
            return Optional.empty();
        }
        for (String argComponent : pluginProtocArgument.split(COMMA)) {
            boolean valueMeetsCriteria;
            String[] args = argComponent.trim().split(EQUALS);
            if (args.length < 2) continue;
            String keyVal = args[0];
            String valueVal = args[1];
            boolean bl = valueMeetsCriteria = keyVal.equals(key) && valueVal.endsWith(fileEnding);
            if (fileEnding.equals(SERVICE_YAML_FILE_ENDING)) {
                valueMeetsCriteria &= !valueVal.endsWith(GAPIC_YAML_FILE_ENDING);
            }
            if (!valueMeetsCriteria) continue;
            return Optional.of(valueVal);
        }
        return Optional.empty();
    }
}

