/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protoparser;

import com.google.api.AnnotationsProto;
import com.google.api.HttpRule;
import com.google.api.generator.gapic.model.Field;
import com.google.api.generator.gapic.model.HttpBindings;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.protoparser.PatternParser;
import com.google.api.pathtemplate.PathTemplate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HttpRuleParser {
    private static final String ASTERISK = "*";
    private static final Pattern TEMPLATE_VALS_PATTERN = Pattern.compile("\\{(?<var>[\\w.]*)=(?<template>[^}]+)}");

    public static HttpBindings parse(Descriptors.MethodDescriptor protoMethod, Message inputMessage, Map<String, Message> messageTypes) {
        DescriptorProtos.MethodOptions methodOptions = protoMethod.getOptions();
        if (!methodOptions.hasExtension(AnnotationsProto.http)) {
            return null;
        }
        HttpRule httpRule = methodOptions.getExtension(AnnotationsProto.http);
        if (!Strings.isNullOrEmpty(httpRule.getBody()) && !httpRule.getBody().equals(ASTERISK)) {
            HttpRuleParser.checkHttpFieldIsValid(httpRule.getBody(), inputMessage, true);
        }
        return HttpRuleParser.parseHttpRuleHelper(httpRule, Optional.of(inputMessage), messageTypes);
    }

    public static HttpBindings parseHttpRule(HttpRule httpRule) {
        return HttpRuleParser.parseHttpRuleHelper(httpRule, Optional.empty(), Collections.emptyMap());
    }

    private static HttpBindings parseHttpRuleHelper(HttpRule httpRule, Optional<Message> inputMessageOpt, Map<String, Message> messageTypes) {
        ImmutableSet<String> queryParamNames;
        ImmutableSet<String> bodyParamNames;
        String pattern = HttpRuleParser.getHttpVerbPattern(httpRule);
        ImmutableSet.Builder bindingsBuilder = ImmutableSet.builder();
        bindingsBuilder.addAll(PatternParser.getPatternBindings(pattern));
        if (httpRule.getAdditionalBindingsCount() > 0) {
            for (HttpRule additionalRule : httpRule.getAdditionalBindingsList()) {
                bindingsBuilder.addAll(PatternParser.getPatternBindings(HttpRuleParser.getHttpVerbPattern(additionalRule)));
            }
        }
        ImmutableCollection pathParamNames = bindingsBuilder.build();
        Map<String, String> patternSampleValues = HttpRuleParser.constructPathValuePatterns(pattern);
        String body = httpRule.getBody();
        if (!inputMessageOpt.isPresent()) {
            bodyParamNames = ImmutableSet.of();
            queryParamNames = ImmutableSet.of();
        } else if (Strings.isNullOrEmpty(body)) {
            bodyParamNames = ImmutableSet.of();
            queryParamNames = Sets.difference(inputMessageOpt.get().fieldMap().keySet(), pathParamNames);
        } else if (body.equals(ASTERISK)) {
            bodyParamNames = Sets.difference(inputMessageOpt.get().fieldMap().keySet(), pathParamNames);
            queryParamNames = ImmutableSet.of();
        } else {
            bodyParamNames = ImmutableSet.of(body);
            Sets.SetView bodyBinidngsUnion = Sets.union(bodyParamNames, pathParamNames);
            queryParamNames = Sets.difference(inputMessageOpt.get().fieldMap().keySet(), bodyBinidngsUnion);
        }
        Message message = inputMessageOpt.orElse(null);
        return HttpBindings.builder().setHttpVerb(HttpBindings.HttpVerb.valueOf(httpRule.getPatternCase().toString())).setPattern(pattern).setAdditionalPatterns(httpRule.getAdditionalBindingsList().stream().map(HttpRuleParser::getHttpVerbPattern).collect(Collectors.toList())).setPathParameters(HttpRuleParser.validateAndConstructHttpBindings((Set<String>)((Object)pathParamNames), message, messageTypes, patternSampleValues)).setQueryParameters(HttpRuleParser.validateAndConstructHttpBindings(queryParamNames, message, messageTypes, null)).setBodyParameters(HttpRuleParser.validateAndConstructHttpBindings(bodyParamNames, message, messageTypes, null)).setIsAsteriskBody(body.equals(ASTERISK)).build();
    }

    private static Set<HttpBindings.HttpBinding> validateAndConstructHttpBindings(Set<String> paramNames, Message inputMessage, Map<String, Message> messageTypes, Map<String, String> patternSampleValues) {
        ImmutableSortedSet.Builder httpBindings = ImmutableSortedSet.naturalOrder();
        for (String paramName : paramNames) {
            String patternSampleValue = patternSampleValues != null ? patternSampleValues.get(paramName) : null;
            String[] subFields = paramName.split("\\.");
            HttpBindings.HttpBinding.Builder httpBindingBuilder = HttpBindings.HttpBinding.builder().setName(paramName);
            if (inputMessage == null) {
                httpBindings.add(httpBindingBuilder.setValuePattern(patternSampleValue).build());
                continue;
            }
            Message nestedMessage = inputMessage;
            for (int i = 0; i < subFields.length; ++i) {
                Field field;
                String subFieldName = subFields[i];
                if (i < subFields.length - 1) {
                    field = nestedMessage.fieldMap().get(subFieldName);
                    nestedMessage = messageTypes.get(field.type().reference().fullName());
                    Preconditions.checkNotNull(nestedMessage, String.format("No containing message found for field %s with type %s", field.name(), field.type().reference().simpleName()));
                    continue;
                }
                if (patternSampleValues != null) {
                    HttpRuleParser.checkHttpFieldIsValid(subFieldName, nestedMessage, false);
                    patternSampleValue = patternSampleValues.get(paramName);
                }
                field = nestedMessage.fieldMap().get(subFieldName);
                httpBindings.add(httpBindingBuilder.setValuePattern(patternSampleValue).setField(field).build());
            }
        }
        return httpBindings.build();
    }

    private static String getHttpVerbPattern(HttpRule httpRule) {
        HttpRule.PatternCase patternCase = httpRule.getPatternCase();
        switch (patternCase) {
            case GET: {
                return httpRule.getGet();
            }
            case PUT: {
                return httpRule.getPut();
            }
            case POST: {
                return httpRule.getPost();
            }
            case DELETE: {
                return httpRule.getDelete();
            }
            case PATCH: {
                return httpRule.getPatch();
            }
        }
        return "";
    }

    private static void checkHttpFieldIsValid(String binding, Message inputMessage, boolean isBody) {
        boolean fieldCondition;
        Preconditions.checkState(!Strings.isNullOrEmpty(binding), String.format("Null or empty binding for " + inputMessage.name(), new Object[0]));
        Preconditions.checkState(inputMessage.fieldMap().containsKey(binding), String.format("Expected message %s to contain field %s but none found", inputMessage.name(), binding));
        Field field = inputMessage.fieldMap().get(binding);
        boolean bl = fieldCondition = !field.isRepeated();
        if (!isBody) {
            fieldCondition &= field.type().isProtoPrimitiveType() || field.isEnum();
        }
        String messageFormat = "Expected a non-repeated " + (isBody ? "" : "primitive ") + "type for field %s in message %s but got type %s";
        Preconditions.checkState(fieldCondition, String.format(messageFormat, field.name(), inputMessage.name(), field.type()));
    }

    private static Map<String, String> constructPathValuePatterns(String pattern) {
        HashMap<String, String> varPattern = new HashMap<String, String>();
        if (pattern == null || pattern.isEmpty()) {
            return varPattern;
        }
        Matcher m = TEMPLATE_VALS_PATTERN.matcher(PathTemplate.create(pattern).toString());
        while (m.find()) {
            varPattern.put(m.group("var"), m.group("template"));
        }
        return varPattern;
    }
}

