/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PackageChecker {
    private PackageChecker() {
    }

    public static boolean isGaApi(String pakkage) {
        String[] packageComponents = pakkage.split("\\.");
        Preconditions.checkState(packageComponents.length > 0, "No subcomponents found in Java package %s", (Object)pakkage);
        String versionComponent = null;
        Matcher matcher = null;
        boolean isFound = false;
        for (int i = packageComponents.length - 1; i >= 0; --i) {
            versionComponent = packageComponents[i];
            matcher = Pattern.compile("^v[0-9]+").matcher(versionComponent);
            isFound = matcher.find();
            if (isFound) break;
        }
        if (!isFound) {
            return true;
        }
        String versionSubstr = versionComponent.replace(matcher.group(), "");
        return Strings.isNullOrEmpty(versionSubstr) || !versionSubstr.contains("alpha") && !versionSubstr.contains("beta");
    }
}

