/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AutoValue_SuperObjectValue;
import com.google.api.generator.engine.ast.ObjectValue;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class SuperObjectValue
implements ObjectValue {
    private static final String SUPER_VALUE = "super";

    @Override
    public abstract TypeNode type();

    @Override
    public String value() {
        return SUPER_VALUE;
    }

    public static SuperObjectValue withType(TypeNode type) {
        return SuperObjectValue.builder().setType(type).build();
    }

    private static Builder builder() {
        return new AutoValue_SuperObjectValue.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setType(TypeNode var1);

        abstract SuperObjectValue autoBuild();

        private SuperObjectValue build() {
            SuperObjectValue superObjectValue = this.autoBuild();
            Preconditions.checkState(TypeNode.isReferenceType(superObjectValue.type()), "The \"super\" can only refer to object types");
            return superObjectValue;
        }
    }
}

